/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.internal.parser;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.internal.parser.TokenType;
import org.jspecify.annotations.Nullable;

public final class Token {
    private final int startIndex;
    private final int endIndex;
    private final TokenType type;
    private @Nullable List<Token> childTokens = null;

    public Token(int startIndex, int endIndex, TokenType type) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.type = type;
    }

    public int startIndex() {
        return this.startIndex;
    }

    public int endIndex() {
        return this.endIndex;
    }

    public TokenType type() {
        return this.type;
    }

    public @Nullable List<Token> childTokens() {
        return this.childTokens;
    }

    public void childTokens(List<Token> childTokens) {
        this.childTokens = childTokens;
    }

    public CharSequence get(CharSequence message) {
        return message.subSequence(this.startIndex, this.endIndex);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Token)) {
            return false;
        }
        Token that = (Token)other;
        return this.startIndex == that.startIndex && this.endIndex == that.endIndex && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startIndex, this.endIndex, this.type});
    }

    public String toString() {
        return "Token{startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", type=" + String.valueOf((Object)this.type) + ", childTokens=" + String.valueOf(this.childTokens) + "}";
    }
}

