/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.resolver;

import java.util.Arrays;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.ClaimConsumer;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jspecify.annotations.Nullable;

record SequentialTagResolver(TagResolver[] resolvers) implements TagResolver,
SerializableResolver
{
    @Override
    public @Nullable Tag resolve(String name, ArgumentQueue arguments, Context ctx) throws ParsingException {
        ParsingException thrown = null;
        for (TagResolver resolver : this.resolvers) {
            try {
                Tag placeholder;
                if (!resolver.has(name) || (placeholder = resolver.resolve(name, arguments, ctx)) == null) continue;
                return placeholder;
            }
            catch (ParsingException ex) {
                arguments.reset();
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
            catch (Exception ex) {
                arguments.reset();
                ParsingException err = ctx.newException("Exception thrown while parsing <" + name + ">", ex, arguments);
                if (thrown == null) {
                    thrown = err;
                    continue;
                }
                thrown.addSuppressed(err);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
        return null;
    }

    @Override
    public boolean has(String name) {
        for (TagResolver resolver : this.resolvers) {
            if (!resolver.has(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handle(Component serializable, ClaimConsumer consumer) {
        for (TagResolver resolver : this.resolvers) {
            if (!(resolver instanceof SerializableResolver)) continue;
            SerializableResolver serializableResolver = (SerializableResolver)((Object)resolver);
            serializableResolver.handle(serializable, consumer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        Object[] resolvers1;
        if (other == this) {
            return true;
        }
        if (!(other instanceof SequentialTagResolver)) return false;
        SequentialTagResolver sequentialTagResolver = (SequentialTagResolver)other;
        try {
            Object[] objectArray;
            resolvers1 = objectArray = sequentialTagResolver.resolvers();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Arrays.equals(this.resolvers, resolvers1);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.resolvers);
    }
}

