/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jspecify.annotations.Nullable;

final class NbtTag {
    static final String NBT = "nbt";
    static final String DATA = "data";
    private static final String BLOCK = "block";
    private static final String ENTITY = "entity";
    private static final String STORAGE = "storage";
    private static final String INTERPRET = "interpret";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(Set.of("nbt", "data"), NbtTag::resolve, NbtTag::emit);

    private NbtTag() {
    }

    static Tag resolve(ArgumentQueue args, Context ctx) throws ParsingException {
        EntityNBTComponent.Builder builder;
        String type;
        switch (type = args.popOr("a type of block, entity, or storage is required").lowerValue()) {
            case "block": {
                String pos = args.popOr("A position is required").value();
                try {
                    builder = Component.blockNBT().pos(BlockNBTComponent.Pos.fromString((String)pos));
                    break;
                }
                catch (IllegalArgumentException ex) {
                    throw ctx.newException(ex.getMessage(), args);
                }
            }
            case "entity": {
                builder = Component.entityNBT().selector(args.popOr("A selector is required").value());
                break;
            }
            case "storage": {
                builder = Component.storageNBT().storage(Key.key((String)args.popOr("A storage key is required").value()));
                break;
            }
            default: {
                throw ctx.newException("Unknown nbt tag type '" + type + "'", args);
            }
        }
        builder.nbtPath(args.popOr("An NBT path is required").value());
        if (args.hasNext()) {
            String popped = args.pop().value();
            if (INTERPRET.equalsIgnoreCase(popped)) {
                builder.interpret(true);
            } else {
                builder.separator((ComponentLike)ctx.deserialize(popped));
                if (args.hasNext() && args.pop().value().equalsIgnoreCase(INTERPRET)) {
                    builder.interpret(true);
                }
            }
        }
        return Tag.inserting(builder.build());
    }

    static @Nullable Emitable emit(Component comp) {
        String id;
        String type;
        Component component = comp;
        Objects.requireNonNull(component);
        Component component2 = component;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockNBTComponent.class, EntityNBTComponent.class, StorageNBTComponent.class}, (Object)component2, n)) {
            case 0: {
                BlockNBTComponent blockNBTComponent = (BlockNBTComponent)component2;
                type = BLOCK;
                id = blockNBTComponent.pos().asString();
                break;
            }
            case 1: {
                EntityNBTComponent entityNBTComponent = (EntityNBTComponent)component2;
                type = ENTITY;
                id = entityNBTComponent.selector();
                break;
            }
            case 2: {
                StorageNBTComponent storageNBTComponent = (StorageNBTComponent)component2;
                type = STORAGE;
                id = storageNBTComponent.storage().asString();
                break;
            }
            default: {
                return null;
            }
        }
        return out -> {
            NBTComponent nbt = (NBTComponent)comp;
            out.tag(NBT).argument(type).argument(id).argument(nbt.nbtPath());
            Component separator = nbt.separator();
            if (separator != null) {
                out.argument(separator);
            }
            if (nbt.interpret()) {
                out.argument(INTERPRET);
            }
        };
    }
}

