/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.GradientTag;

final class PrideTag
extends GradientTag {
    static final String PRIDE = "pride";
    static final TagResolver RESOLVER = TagResolver.resolver("pride", PrideTag::create);
    private static final Map<String, List<TextColor>> FLAGS = Map.ofEntries(Map.entry("pride", PrideTag.colors(0xE50000, 16747776, 0xFFEE00, 164129, 19711, 0x770088)), Map.entry("progress", PrideTag.colors(0xFFFFFF, 16756679, 7591918, 6371605, 0, 0xE50000, 16747776, 0xFFEE00, 164129, 19711, 0x770088)), Map.entry("trans", PrideTag.colors(6017019, 16100281, 0xFFFFFF, 16100281, 6017019)), Map.entry("bi", PrideTag.colors(14025328, 10178454, 14504)), Map.entry("pan", PrideTag.colors(16718989, 16766720, 1750015)), Map.entry("nb", PrideTag.colors(16577585, 0xFCFCFC, 10312146, 0x282828)), Map.entry("lesbian", PrideTag.colors(14034944, 16751446, 0xFFFFFF, 13918886, 10748002)), Map.entry("ace", PrideTag.colors(0, 0xA4A4A4, 0xFFFFFF, 0x810081)), Map.entry("agender", PrideTag.colors(0, 0xBABABA, 0xFFFFFF, 12252292, 0xFFFFFF, 0xBABABA, 0)), Map.entry("demisexual", PrideTag.colors(0, 0xFFFFFF, 7209073, 0xD3D3D3)), Map.entry("genderqueer", PrideTag.colors(11894749, 0xFFFFFF, 4817438)), Map.entry("genderfluid", PrideTag.colors(16676514, 0xFFFFFF, 12522199, 0, 3161278)), Map.entry("intersex", PrideTag.colors(16766976, 7930538, 16766976)), Map.entry("aro", PrideTag.colors(3909440, 11064442, 0xFFFFFF, 0xABABAB, 0)), Map.entry("femboy", PrideTag.colors(13787301, 14987213, 0xFEFEFE, 5754616, 0xFEFEFE, 14987213, 13787301)), Map.entry("baker", PrideTag.colors(13461247, 16737689, 0xFE0000, 16685312, 0xFFFF01, 39168, 39371, 3473561, 0x990099)), Map.entry("philly", PrideTag.colors(0, 7884567, 0xFE0000, 16616448, 16770304, 1154827, 410803, 12725980)), Map.entry("queer", PrideTag.colors(0, 10148330, 41960, 11920669, 0xFFFFFF, 16763149, 16541287, 16690889, 0)), Map.entry("gay", PrideTag.colors(495216, 2543274, 10021057, 0xFFFFFF, 8105442, 5261771, 4004472)), Map.entry("bigender", PrideTag.colors(12876192, 15509195, 14010344, 0xFFFFFF, 14010344, 10143720, 7111631)), Map.entry("demigender", PrideTag.colors(0x7F7F7F, 0xC3C3C3, 16514932, 0xFFFFFF, 16514932, 0xC3C3C3, 0x7F7F7F)));
    private final String flag;

    static Tag create(ArgumentQueue args, Context ctx) {
        double phase = 0.0;
        String flag = PRIDE;
        if (args.hasNext()) {
            String value = args.pop().value().toLowerCase(Locale.ROOT);
            if (FLAGS.containsKey(value)) {
                flag = value;
            } else if (!value.isEmpty()) {
                try {
                    phase = Double.parseDouble(value);
                }
                catch (NumberFormatException ex) {
                    throw ctx.newException("Expected phase, got " + value);
                }
                if (phase < -1.0 || phase > 1.0) {
                    throw ctx.newException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0, 1.0] (inclusive).", phase), args);
                }
            }
        }
        return new PrideTag(phase, FLAGS.get(flag), flag, ctx);
    }

    PrideTag(double phase, List<TextColor> colors, String flag, Context ctx) {
        super(phase, colors, ctx);
        this.flag = flag;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.flag, this.phase);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrideTag)) {
            return false;
        }
        PrideTag that = (PrideTag)other;
        return this.phase == that.phase && this.flag.equals(that.flag);
    }

    @Override
    public String toString() {
        return "PrideTag{flag='" + this.flag + "', phase=" + this.phase + "}";
    }

    private static List<TextColor> colors(int ... colors) {
        return Arrays.stream(colors).mapToObj(TextColor::color).collect(Collectors.toList());
    }
}

