/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jspecify.annotations.Nullable;

final class SelectorTag {
    static final String SEL = "sel";
    static final String SELECTOR = "selector";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(Set.of("sel", "selector"), SelectorTag::create, SelectorTag::claim);

    private SelectorTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String key = args.popOr("A selection key is required").value();
        Component separator = null;
        if (args.hasNext()) {
            separator = ctx.deserialize(args.pop().value());
        }
        return Tag.inserting((Component)Component.selector((String)key, separator));
    }

    static @Nullable Emitable claim(Component input) {
        if (!(input instanceof SelectorComponent)) {
            return null;
        }
        SelectorComponent st = (SelectorComponent)input;
        return emit -> {
            emit.tag(SEL);
            emit.argument(st.pattern());
            Component separator = st.separator();
            if (separator != null) {
                emit.argument(separator);
            }
        };
    }
}

