/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jspecify.annotations.Nullable;

final class TranslatableFallbackTag {
    static final String TR_OR = "tr_or";
    static final String TRANSLATE_OR = "translate_or";
    static final String LANG_OR = "lang_or";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(Set.of("lang_or", "translate_or", "tr_or"), TranslatableFallbackTag::create, TranslatableFallbackTag::claim);

    private TranslatableFallbackTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String key = args.popOr("A translation key is required").value();
        String fallback = args.popOr("A fallback messages is required").value();
        return Tag.inserting((Component)Component.translatable((String)key, (String)fallback, TranslatableFallbackTag.constructWith(args, ctx), (StyleBuilderApplicable[])new StyleBuilderApplicable[0]));
    }

    static List<Component> constructWith(ArgumentQueue args, Context ctx) {
        List<Component> with;
        if (args.hasNext()) {
            with = new ArrayList();
            while (args.hasNext()) {
                with.add(ctx.deserialize(args.pop().value()));
            }
        } else {
            with = List.of();
        }
        return with;
    }

    static @Nullable Emitable claim(Component input) {
        TranslatableComponent tr;
        if (!(input instanceof TranslatableComponent) || (tr = (TranslatableComponent)input).fallback() == null) {
            return null;
        }
        return emit -> {
            emit.tag(LANG_OR);
            emit.argument(tr.key());
            emit.argument(tr.fallback());
            for (TranslationArgument with : tr.arguments()) {
                emit.argument(with.asComponent());
            }
        };
    }
}

