/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.gson.SerializerFactory;
import net.kyori.adventure.text.serializer.json.JSONOptions;
import net.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import net.kyori.adventure.util.Services;
import net.kyori.option.OptionState;
import org.jspecify.annotations.Nullable;

final class GsonComponentSerializerImpl
implements GsonComponentSerializer {
    private static final Optional<GsonComponentSerializer.Provider> SERVICE = Services.service(GsonComponentSerializer.Provider.class);
    static final Consumer<GsonComponentSerializer.Builder> BUILDER = SERVICE.map(GsonComponentSerializer.Provider::builder).orElseGet(() -> builder -> {});
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator;
    private final @Nullable LegacyHoverEventSerializer legacyHoverSerializer;
    private final OptionState flags;

    GsonComponentSerializerImpl(OptionState flags, @Nullable LegacyHoverEventSerializer legacyHoverSerializer) {
        this.flags = flags;
        this.legacyHoverSerializer = legacyHoverSerializer;
        this.populator = builder -> {
            builder.registerTypeAdapterFactory((TypeAdapterFactory)new SerializerFactory(flags, legacyHoverSerializer));
            return builder;
        };
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder().disableHtmlEscaping())).create();
    }

    @Override
    public Gson serializer() {
        return this.serializer;
    }

    @Override
    public UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    public Component deserialize(String string) {
        return (Component)this.serializer().fromJson(string, Component.class);
    }

    public @Nullable Component deserializeOr(@Nullable String input, @Nullable Component fallback) {
        if (input == null) {
            return fallback;
        }
        return (Component)this.serializer().fromJson(input, Component.class);
    }

    public String serialize(Component component) {
        return this.serializer().toJson((Object)component);
    }

    @Override
    public Component deserializeFromTree(JsonElement input) {
        return (Component)this.serializer().fromJson(input, Component.class);
    }

    @Override
    public JsonElement serializeToTree(Component component) {
        return this.serializer().toJsonTree((Object)component);
    }

    @Override
    public GsonComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements GsonComponentSerializer.Builder {
        private OptionState flags = JSONOptions.byDataVersion();
        private @Nullable LegacyHoverEventSerializer legacyHoverSerializer;

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(GsonComponentSerializerImpl serializer) {
            this();
            this.flags = serializer.flags;
            this.legacyHoverSerializer = serializer.legacyHoverSerializer;
        }

        @Override
        public GsonComponentSerializer.Builder options(OptionState flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        @Override
        public GsonComponentSerializer.Builder editOptions(Consumer<OptionState.Builder> optionEditor) {
            OptionState.Builder builder = JSONOptions.schema().stateBuilder().values(this.flags);
            Objects.requireNonNull(optionEditor, "flagEditor").accept(builder);
            this.flags = builder.build();
            return this;
        }

        @Override
        public GsonComponentSerializer.Builder legacyHoverEventSerializer(@Nullable LegacyHoverEventSerializer serializer) {
            this.legacyHoverSerializer = serializer;
            return this;
        }

        @Override
        public GsonComponentSerializer build() {
            return new GsonComponentSerializerImpl(this.flags, this.legacyHoverSerializer);
        }
    }

    static final class Instances {
        static final GsonComponentSerializer INSTANCE = SERVICE.map(GsonComponentSerializer.Provider::gson).orElseGet(() -> new GsonComponentSerializerImpl((OptionState)JSONOptions.byDataVersion(), null));
        static final GsonComponentSerializer LEGACY_INSTANCE = SERVICE.map(GsonComponentSerializer.Provider::gsonLegacy).orElseGet(() -> new GsonComponentSerializerImpl((OptionState)JSONOptions.byDataVersion().at(2525), null));

        Instances() {
        }
    }
}

