/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContents;
import net.kyori.adventure.text.serializer.gson.GsonHacks;
import net.kyori.adventure.text.serializer.gson.SerializerFactory;
import net.kyori.adventure.text.serializer.json.JSONOptions;
import net.kyori.option.OptionState;
import org.jspecify.annotations.Nullable;

final class ComponentSerializerImpl
extends TypeAdapter<Component> {
    static final Type COMPONENT_LIST_TYPE = new TypeToken<List<Component>>(){}.getType();
    static final Type TRANSLATABLE_ARGUMENT_LIST_TYPE = new TypeToken<List<TranslationArgument>>(){}.getType();
    static final Type PROPERTY_LIST_TYPE = new TypeToken<List<PlayerHeadObjectContents.ProfileProperty>>(){}.getType();
    private final boolean emitCompactTextComponent;
    private final Gson gson;

    static TypeAdapter<Component> create(OptionState features, Gson gson) {
        return new ComponentSerializerImpl((Boolean)features.value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT), gson).nullSafe();
    }

    private ComponentSerializerImpl(boolean emitCompactTextComponent, Gson gson) {
        this.emitCompactTextComponent = emitCompactTextComponent;
        this.gson = gson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component read(JsonReader in) throws IOException {
        TextComponent.Builder builder;
        JsonToken token = in.peek();
        if (token == JsonToken.STRING || token == JsonToken.NUMBER || token == JsonToken.BOOLEAN) {
            return Component.text((String)GsonHacks.readString(in));
        }
        if (token == JsonToken.BEGIN_ARRAY) {
            ComponentBuilder parent = null;
            in.beginArray();
            while (in.hasNext()) {
                Component child = this.read(in);
                if (parent == null) {
                    parent = child.toBuilder();
                    continue;
                }
                parent.append(child);
            }
            if (parent == null) {
                throw ComponentSerializerImpl.notSureHowToDeserialize(in.getPath());
            }
            in.endArray();
            return parent.build();
        }
        if (token != JsonToken.BEGIN_OBJECT) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(in.getPath());
        }
        JsonObject style = new JsonObject();
        List extra = List.of();
        String text = null;
        String translate = null;
        String translateFallback = null;
        List translateWith = null;
        String scoreName = null;
        String scoreObjective = null;
        String scoreValue = null;
        String selector = null;
        String keybind = null;
        String nbt = null;
        boolean nbtInterpret = false;
        BlockNBTComponent.Pos nbtBlock = null;
        String nbtEntity = null;
        Key nbtStorage = null;
        Component separator = null;
        Key atlas = null;
        Key sprite = null;
        PlayerHeadObjectContents.Builder playerHeadContents = null;
        boolean playerHeadContentsHasProfile = false;
        in.beginObject();
        while (in.hasNext()) {
            String fieldName;
            switch (fieldName = in.nextName()) {
                case "text": {
                    text = GsonHacks.readString(in);
                    break;
                }
                case "translate": {
                    translate = in.nextString();
                    break;
                }
                case "fallback": {
                    translateFallback = in.nextString();
                    break;
                }
                case "with": {
                    translateWith = (List)this.gson.fromJson(in, TRANSLATABLE_ARGUMENT_LIST_TYPE);
                    break;
                }
                case "score": {
                    in.beginObject();
                    block64: while (in.hasNext()) {
                        String scoreFieldName;
                        switch (scoreFieldName = in.nextName()) {
                            case "name": {
                                scoreName = in.nextString();
                                continue block64;
                            }
                            case "objective": {
                                scoreObjective = in.nextString();
                                continue block64;
                            }
                            case "value": {
                                scoreValue = in.nextString();
                                continue block64;
                            }
                        }
                        in.skipValue();
                    }
                    if (scoreName == null || scoreObjective == null) {
                        throw new JsonParseException("A score component requires a name and objective");
                    }
                    in.endObject();
                    break;
                }
                case "selector": {
                    selector = in.nextString();
                    break;
                }
                case "keybind": {
                    keybind = in.nextString();
                    break;
                }
                case "nbt": {
                    nbt = in.nextString();
                    break;
                }
                case "interpret": {
                    nbtInterpret = in.nextBoolean();
                    break;
                }
                case "block": {
                    nbtBlock = (BlockNBTComponent.Pos)this.gson.fromJson(in, SerializerFactory.BLOCK_NBT_POS_TYPE);
                    break;
                }
                case "entity": {
                    nbtEntity = in.nextString();
                    break;
                }
                case "storage": {
                    nbtStorage = (Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE);
                    break;
                }
                case "extra": {
                    extra = (List)this.gson.fromJson(in, COMPONENT_LIST_TYPE);
                    break;
                }
                case "separator": {
                    separator = this.read(in);
                    break;
                }
                case "atlas": {
                    atlas = (Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE);
                    break;
                }
                case "sprite": {
                    sprite = (Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE);
                    break;
                }
                case "player": {
                    JsonToken playerToken;
                    if (playerHeadContents == null) {
                        playerHeadContents = ObjectContents.playerHead();
                    }
                    if ((playerToken = in.peek()) == JsonToken.STRING) {
                        playerHeadContentsHasProfile = true;
                        playerHeadContents.name(in.nextString());
                        break;
                    }
                    if (playerToken == JsonToken.BEGIN_OBJECT) {
                        playerHeadContentsHasProfile = true;
                        in.beginObject();
                        while (in.hasNext()) {
                            String playerHeadFieldName;
                            switch (playerHeadFieldName = in.nextName()) {
                                case "name": {
                                    playerHeadContents.name(in.nextString());
                                    break;
                                }
                                case "id": {
                                    playerHeadContents.id((UUID)this.gson.fromJson(in, SerializerFactory.UUID_TYPE));
                                    break;
                                }
                                case "properties": {
                                    JsonToken propertyToken = in.peek();
                                    if (propertyToken == JsonToken.BEGIN_ARRAY) {
                                        playerHeadContents.profileProperties((Collection)this.gson.fromJson(in, PROPERTY_LIST_TYPE));
                                        break;
                                    }
                                    if (propertyToken == JsonToken.BEGIN_OBJECT) {
                                        in.beginObject();
                                        while (in.hasNext()) {
                                            String propertyName = in.nextName();
                                            in.beginArray();
                                            while (in.hasNext()) {
                                                playerHeadContents.profileProperty(PlayerHeadObjectContents.property((String)propertyName, (String)in.nextString()));
                                            }
                                            in.endArray();
                                        }
                                        in.endObject();
                                        break;
                                    }
                                    in.skipValue();
                                    break;
                                }
                                case "texture": {
                                    playerHeadContents.texture((Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE));
                                    break;
                                }
                                default: {
                                    in.skipValue();
                                }
                            }
                        }
                        in.endObject();
                        break;
                    }
                    in.skipValue();
                    break;
                }
                case "hat": {
                    if (playerHeadContents == null) {
                        playerHeadContents = ObjectContents.playerHead();
                    }
                    playerHeadContents.hat(in.nextBoolean());
                    break;
                }
                default: {
                    style.add(fieldName, (JsonElement)this.gson.fromJson(in, JsonElement.class));
                }
            }
        }
        if (text != null) {
            builder = Component.text().content(text);
        } else if (translate != null) {
            builder = translateWith != null ? Component.translatable().key(translate).fallback(translateFallback).arguments(translateWith) : Component.translatable().key(translate).fallback(translateFallback);
        } else if (scoreName != null && scoreObjective != null) {
            builder = scoreValue == null ? Component.score().name(scoreName).objective(scoreObjective) : Component.score().name(scoreName).objective(scoreObjective).value(scoreValue);
        } else if (selector != null) {
            builder = Component.selector().pattern(selector).separator(separator);
        } else if (keybind != null) {
            builder = Component.keybind().keybind(keybind);
        } else if (nbt != null) {
            if (nbtBlock != null) {
                builder = ComponentSerializerImpl.nbt(Component.blockNBT(), nbt, nbtInterpret, separator).pos(nbtBlock);
            } else if (nbtEntity != null) {
                builder = ComponentSerializerImpl.nbt(Component.entityNBT(), nbt, nbtInterpret, separator).selector(nbtEntity);
            } else {
                if (nbtStorage == null) throw ComponentSerializerImpl.notSureHowToDeserialize(in.getPath());
                builder = ComponentSerializerImpl.nbt(Component.storageNBT(), nbt, nbtInterpret, separator).storage(nbtStorage);
            }
        } else if (sprite != null) {
            builder = Component.object().contents((ObjectContents)ObjectContents.sprite((Key)(atlas != null ? atlas : SpriteObjectContents.DEFAULT_ATLAS), (Key)sprite));
        } else {
            if (playerHeadContents == null || !playerHeadContentsHasProfile) throw ComponentSerializerImpl.notSureHowToDeserialize(in.getPath());
            builder = Component.object().contents((ObjectContents)playerHeadContents.build());
        }
        builder.style((Style)this.gson.fromJson((JsonElement)style, SerializerFactory.STYLE_TYPE)).append(extra);
        in.endObject();
        return builder.build();
    }

    private static <C extends NBTComponent<C>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret, @Nullable Component separator) {
        return (B)builder.nbtPath(nbt).interpret(interpret).separator((ComponentLike)separator);
    }

    public void write(JsonWriter out, Component value) throws IOException {
        JsonElement style;
        if (value instanceof TextComponent && value.children().isEmpty() && !value.hasStyling() && this.emitCompactTextComponent) {
            out.value(((TextComponent)value).content());
            return;
        }
        out.beginObject();
        if (value.hasStyling() && (style = this.gson.toJsonTree((Object)value.style(), SerializerFactory.STYLE_TYPE)).isJsonObject()) {
            for (Map.Entry entry : style.getAsJsonObject().entrySet()) {
                out.name((String)entry.getKey());
                this.gson.toJson((JsonElement)entry.getValue(), out);
            }
        }
        if (!value.children().isEmpty()) {
            out.name("extra");
            this.gson.toJson((Object)value.children(), COMPONENT_LIST_TYPE, out);
        }
        Component component = value;
        Objects.requireNonNull(component);
        Component component2 = component;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextComponent.class, TranslatableComponent.class, ScoreComponent.class, SelectorComponent.class, KeybindComponent.class, NBTComponent.class, ObjectComponent.class}, (Object)component2, n)) {
            case 0: {
                TextComponent textComponent = (TextComponent)component2;
                out.name("text");
                out.value(textComponent.content());
                break;
            }
            case 1: {
                TranslatableComponent translatable = (TranslatableComponent)component2;
                out.name("translate");
                out.value(translatable.key());
                String fallback = translatable.fallback();
                if (fallback != null) {
                    out.name("fallback");
                    out.value(fallback);
                }
                if (translatable.arguments().isEmpty()) break;
                out.name("with");
                this.gson.toJson((Object)translatable.arguments(), TRANSLATABLE_ARGUMENT_LIST_TYPE, out);
                break;
            }
            case 2: {
                ScoreComponent score = (ScoreComponent)component2;
                out.name("score");
                out.beginObject();
                out.name("name");
                out.value(score.name());
                out.name("objective");
                out.value(score.objective());
                if (score.value() != null) {
                    out.name("value");
                    out.value(score.value());
                }
                out.endObject();
                break;
            }
            case 3: {
                SelectorComponent selector = (SelectorComponent)component2;
                out.name("selector");
                out.value(selector.pattern());
                this.serializeSeparator(out, selector.separator());
                break;
            }
            case 4: {
                KeybindComponent keybindComponent = (KeybindComponent)component2;
                out.name("keybind");
                out.value(keybindComponent.keybind());
                break;
            }
            case 5: {
                NBTComponent nbt = (NBTComponent)component2;
                out.name("nbt");
                out.value(nbt.nbtPath());
                out.name("interpret");
                out.value(nbt.interpret());
                this.serializeSeparator(out, nbt.separator());
                Component component3 = value;
                Objects.requireNonNull(component3);
                Component component4 = component3;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockNBTComponent.class, EntityNBTComponent.class, StorageNBTComponent.class}, (Object)component4, n2)) {
                    case 0: {
                        BlockNBTComponent blockNBTComponent = (BlockNBTComponent)component4;
                        out.name("block");
                        this.gson.toJson((Object)blockNBTComponent.pos(), SerializerFactory.BLOCK_NBT_POS_TYPE, out);
                        break block0;
                    }
                    case 1: {
                        EntityNBTComponent entityNBTComponent = (EntityNBTComponent)component4;
                        out.name("entity");
                        out.value(entityNBTComponent.selector());
                        break block0;
                    }
                    case 2: {
                        StorageNBTComponent storageNBTComponent = (StorageNBTComponent)component4;
                        out.name("storage");
                        this.gson.toJson((Object)storageNBTComponent.storage(), SerializerFactory.KEY_TYPE, out);
                        break block0;
                    }
                }
                throw ComponentSerializerImpl.notSureHowToSerialize(value);
            }
            case 6: {
                ObjectComponent objectComponent = (ObjectComponent)component2;
                ObjectContents contents = objectComponent.contents();
                if (contents instanceof SpriteObjectContents) {
                    SpriteObjectContents spriteContents = (SpriteObjectContents)contents;
                    if (!spriteContents.atlas().equals((Object)SpriteObjectContents.DEFAULT_ATLAS)) {
                        out.name("atlas");
                        this.gson.toJson((Object)spriteContents.atlas(), SerializerFactory.KEY_TYPE, out);
                    }
                    out.name("sprite");
                    this.gson.toJson((Object)spriteContents.sprite(), SerializerFactory.KEY_TYPE, out);
                    break;
                }
                if (contents instanceof PlayerHeadObjectContents) {
                    PlayerHeadObjectContents playerHeadContents = (PlayerHeadObjectContents)contents;
                    out.name("hat");
                    out.value(playerHeadContents.hat());
                    String playerName = playerHeadContents.name();
                    UUID playerId = playerHeadContents.id();
                    List properties = playerHeadContents.profileProperties();
                    Key texture = playerHeadContents.texture();
                    out.name("player");
                    if (playerName != null && playerId == null && properties.isEmpty() && texture == null) {
                        out.value(playerName);
                        break;
                    }
                    out.beginObject();
                    if (playerName != null) {
                        out.name("name");
                        out.value(playerName);
                    }
                    if (playerId != null) {
                        out.name("id");
                        this.gson.toJson((Object)playerId, SerializerFactory.UUID_TYPE, out);
                    }
                    if (!properties.isEmpty()) {
                        out.name("properties");
                        this.gson.toJson((Object)properties, PROPERTY_LIST_TYPE, out);
                    }
                    if (texture != null) {
                        out.name("texture");
                        this.gson.toJson((Object)texture, SerializerFactory.KEY_TYPE, out);
                    }
                    out.endObject();
                    break;
                }
                throw ComponentSerializerImpl.notSureHowToSerialize(value);
            }
            default: {
                throw ComponentSerializerImpl.notSureHowToSerialize(value);
            }
        }
        out.endObject();
    }

    private void serializeSeparator(JsonWriter out, @Nullable Component separator) throws IOException {
        if (separator != null) {
            out.name("separator");
            this.write(out, separator);
        }
    }

    static JsonParseException notSureHowToDeserialize(Object element) {
        return new JsonParseException("Don't know how to turn " + String.valueOf(element) + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + String.valueOf(component) + " as a Component");
    }
}

