/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.serializer.gson.SerializerFactory;

final class TranslationArgumentSerializer
extends TypeAdapter<TranslationArgument> {
    private final Gson gson;

    static TypeAdapter<TranslationArgument> create(Gson gson) {
        return new TranslationArgumentSerializer(gson).nullSafe();
    }

    private TranslationArgumentSerializer(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, TranslationArgument value) throws IOException {
        Object raw;
        Object object = raw = value.value();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Number.class, Component.class}, (Object)object2, n)) {
            case 0: {
                Boolean b = (Boolean)object2;
                out.value(b);
                break;
            }
            case 1: {
                Number number = (Number)object2;
                out.value(number);
                break;
            }
            case 2: {
                Component ignored = (Component)object2;
                this.gson.toJson(raw, SerializerFactory.COMPONENT_TYPE, out);
                break;
            }
            default: {
                throw new IllegalStateException("Unable to serialize translatable argument of type " + String.valueOf(raw.getClass()) + ": " + String.valueOf(raw));
            }
        }
    }

    public TranslationArgument read(JsonReader in) throws IOException {
        return switch (in.peek()) {
            case JsonToken.BOOLEAN -> TranslationArgument.bool((boolean)in.nextBoolean());
            case JsonToken.NUMBER -> TranslationArgument.numeric((Number)((Number)this.gson.fromJson(in, Number.class)));
            default -> TranslationArgument.component((ComponentLike)((ComponentLike)this.gson.fromJson(in, SerializerFactory.COMPONENT_TYPE)));
        };
    }
}

