/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.legacy;

import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.CharacterAndFormat;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializerImpl;
import net.kyori.adventure.text.serializer.legacy.LegacyFormat;
import net.kyori.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public interface LegacyComponentSerializer
extends ComponentSerializer<Component, TextComponent, String> {
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';
    public static final char HEX_CHAR = '#';

    public static LegacyComponentSerializer legacySection() {
        return LegacyComponentSerializerImpl.Instances.SECTION;
    }

    public static LegacyComponentSerializer legacyAmpersand() {
        return LegacyComponentSerializerImpl.Instances.AMPERSAND;
    }

    public static LegacyComponentSerializer legacy(char legacyCharacter) {
        if (legacyCharacter == '\u00a7') {
            return LegacyComponentSerializer.legacySection();
        }
        if (legacyCharacter == '&') {
            return LegacyComponentSerializer.legacyAmpersand();
        }
        return LegacyComponentSerializer.builder().character(legacyCharacter).build();
    }

    public static @Nullable LegacyFormat parseChar(char character) {
        return LegacyComponentSerializerImpl.legacyFormat(character);
    }

    public static Builder builder() {
        return new LegacyComponentSerializerImpl.BuilderImpl();
    }

    public TextComponent deserialize(String var1);

    public String serialize(Component var1);

    public Builder toBuilder();

    public static interface Builder
    extends AbstractBuilder<LegacyComponentSerializer> {
        public Builder character(char var1);

        public Builder hexCharacter(char var1);

        public Builder extractUrls();

        public Builder extractUrls(Pattern var1);

        public Builder extractUrls(@Nullable Style var1);

        public Builder extractUrls(Pattern var1, @Nullable Style var2);

        public Builder hexColors();

        public Builder useUnusualXRepeatedCharacterHexFormat();

        public Builder flattener(ComponentFlattener var1);

        public Builder formats(List<CharacterAndFormat> var1);

        public LegacyComponentSerializer build();
    }

    @PlatformAPI
    @ApiStatus.Internal
    public static interface Provider {
        @PlatformAPI
        @ApiStatus.Internal
        public LegacyComponentSerializer legacyAmpersand();

        @PlatformAPI
        @ApiStatus.Internal
        public LegacyComponentSerializer legacySection();

        @PlatformAPI
        @ApiStatus.Internal
        public Consumer<Builder> legacy();
    }
}

