/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.legacy;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.serializer.legacy.CharacterAndFormatImpl;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public sealed interface CharacterAndFormat
permits CharacterAndFormatImpl {
    public static final CharacterAndFormat BLACK = CharacterAndFormat.characterAndFormat('0', (TextFormat)NamedTextColor.BLACK, true);
    public static final CharacterAndFormat DARK_BLUE = CharacterAndFormat.characterAndFormat('1', (TextFormat)NamedTextColor.DARK_BLUE, true);
    public static final CharacterAndFormat DARK_GREEN = CharacterAndFormat.characterAndFormat('2', (TextFormat)NamedTextColor.DARK_GREEN, true);
    public static final CharacterAndFormat DARK_AQUA = CharacterAndFormat.characterAndFormat('3', (TextFormat)NamedTextColor.DARK_AQUA, true);
    public static final CharacterAndFormat DARK_RED = CharacterAndFormat.characterAndFormat('4', (TextFormat)NamedTextColor.DARK_RED, true);
    public static final CharacterAndFormat DARK_PURPLE = CharacterAndFormat.characterAndFormat('5', (TextFormat)NamedTextColor.DARK_PURPLE, true);
    public static final CharacterAndFormat GOLD = CharacterAndFormat.characterAndFormat('6', (TextFormat)NamedTextColor.GOLD, true);
    public static final CharacterAndFormat GRAY = CharacterAndFormat.characterAndFormat('7', (TextFormat)NamedTextColor.GRAY, true);
    public static final CharacterAndFormat DARK_GRAY = CharacterAndFormat.characterAndFormat('8', (TextFormat)NamedTextColor.DARK_GRAY, true);
    public static final CharacterAndFormat BLUE = CharacterAndFormat.characterAndFormat('9', (TextFormat)NamedTextColor.BLUE, true);
    public static final CharacterAndFormat GREEN = CharacterAndFormat.characterAndFormat('a', (TextFormat)NamedTextColor.GREEN, true);
    public static final CharacterAndFormat AQUA = CharacterAndFormat.characterAndFormat('b', (TextFormat)NamedTextColor.AQUA, true);
    public static final CharacterAndFormat RED = CharacterAndFormat.characterAndFormat('c', (TextFormat)NamedTextColor.RED, true);
    public static final CharacterAndFormat LIGHT_PURPLE = CharacterAndFormat.characterAndFormat('d', (TextFormat)NamedTextColor.LIGHT_PURPLE, true);
    public static final CharacterAndFormat YELLOW = CharacterAndFormat.characterAndFormat('e', (TextFormat)NamedTextColor.YELLOW, true);
    public static final CharacterAndFormat WHITE = CharacterAndFormat.characterAndFormat('f', (TextFormat)NamedTextColor.WHITE, true);
    public static final CharacterAndFormat OBFUSCATED = CharacterAndFormat.characterAndFormat('k', (TextFormat)TextDecoration.OBFUSCATED, true);
    public static final CharacterAndFormat BOLD = CharacterAndFormat.characterAndFormat('l', (TextFormat)TextDecoration.BOLD, true);
    public static final CharacterAndFormat STRIKETHROUGH = CharacterAndFormat.characterAndFormat('m', (TextFormat)TextDecoration.STRIKETHROUGH, true);
    public static final CharacterAndFormat UNDERLINED = CharacterAndFormat.characterAndFormat('n', (TextFormat)TextDecoration.UNDERLINED, true);
    public static final CharacterAndFormat ITALIC = CharacterAndFormat.characterAndFormat('o', (TextFormat)TextDecoration.ITALIC, true);
    public static final CharacterAndFormat RESET = CharacterAndFormat.characterAndReset('r', true);

    public static CharacterAndFormat characterAndReset(char character) {
        return CharacterAndFormat.characterAndReset(character, false);
    }

    public static CharacterAndFormat characterAndReset(char character, boolean caseInsensitive) {
        return new CharacterAndFormatImpl(character, null, caseInsensitive);
    }

    public static CharacterAndFormat characterAndFormat(char character, TextFormat format) {
        return CharacterAndFormat.characterAndFormat(character, format, false);
    }

    public static CharacterAndFormat characterAndFormat(char character, TextFormat format, boolean caseInsensitive) {
        return new CharacterAndFormatImpl(character, Objects.requireNonNull(format, "format"), caseInsensitive);
    }

    public static @Unmodifiable List<CharacterAndFormat> defaults() {
        return CharacterAndFormatImpl.Defaults.DEFAULTS;
    }

    public char character();

    public @Nullable TextFormat format();

    public boolean caseInsensitive();
}

