/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.plain;

import java.util.function.Consumer;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializerImpl;
import net.kyori.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;

public interface PlainTextComponentSerializer
extends ComponentSerializer<Component, TextComponent, String> {
    public static PlainTextComponentSerializer plainText() {
        return PlainTextComponentSerializerImpl.Instances.INSTANCE;
    }

    public static Builder builder() {
        return new PlainTextComponentSerializerImpl.BuilderImpl();
    }

    default public TextComponent deserialize(String input) {
        return Component.text((String)input);
    }

    default public String serialize(Component component) {
        StringBuilder sb = new StringBuilder();
        this.serialize(sb, component);
        return sb.toString();
    }

    public void serialize(StringBuilder var1, Component var2);

    public Builder toBuilder();

    @PlatformAPI
    @ApiStatus.Internal
    public static interface Provider {
        @PlatformAPI
        @ApiStatus.Internal
        public PlainTextComponentSerializer plainTextSimple();

        @PlatformAPI
        @ApiStatus.Internal
        public Consumer<Builder> plainText();
    }

    public static interface Builder
    extends AbstractBuilder<PlainTextComponentSerializer> {
        public Builder flattener(ComponentFlattener var1);
    }
}

