/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.plain;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.util.Services;

final class PlainTextComponentSerializerImpl
implements PlainTextComponentSerializer {
    private static final ComponentFlattener DEFAULT_FLATTENER = (ComponentFlattener)ComponentFlattener.basic().toBuilder().unknownMapper(component -> {
        throw new UnsupportedOperationException("Don't know how to turn " + component.getClass().getSimpleName() + " into a string");
    }).build();
    private static final Optional<PlainTextComponentSerializer.Provider> SERVICE = Services.service(PlainTextComponentSerializer.Provider.class);
    static final Consumer<PlainTextComponentSerializer.Builder> BUILDER = SERVICE.map(PlainTextComponentSerializer.Provider::plainText).orElseGet(() -> builder -> {});
    final ComponentFlattener flattener;

    PlainTextComponentSerializerImpl(ComponentFlattener flattener) {
        this.flattener = flattener;
    }

    @Override
    public void serialize(StringBuilder sb, Component component) {
        this.flattener.flatten(Objects.requireNonNull(component, "component"), sb::append);
    }

    @Override
    public PlainTextComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements PlainTextComponentSerializer.Builder {
        private ComponentFlattener flattener = DEFAULT_FLATTENER;

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(PlainTextComponentSerializerImpl serializer) {
            this();
            this.flattener = serializer.flattener;
        }

        @Override
        public PlainTextComponentSerializer.Builder flattener(ComponentFlattener flattener) {
            this.flattener = Objects.requireNonNull(flattener, "flattener");
            return this;
        }

        public PlainTextComponentSerializer build() {
            return new PlainTextComponentSerializerImpl(this.flattener);
        }
    }

    static final class Instances {
        static final PlainTextComponentSerializer INSTANCE = SERVICE.map(PlainTextComponentSerializer.Provider::plainTextSimple).orElseGet(() -> new PlainTextComponentSerializerImpl(DEFAULT_FLATTENER));

        Instances() {
        }
    }
}

