/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.bytecode.impl.classfile;

import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.MethodSignature;
import java.lang.classfile.Signature;
import java.lang.classfile.attribute.ConstantValueAttribute;
import java.lang.classfile.attribute.ExceptionsAttribute;
import java.lang.classfile.attribute.SignatureAttribute;
import java.lang.classfile.constantpool.ConstantValueEntry;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import net.lenni0451.reflect.bytecode.builder.FieldBuilder;
import net.lenni0451.reflect.bytecode.builder.MethodBuilder;
import net.lenni0451.reflect.bytecode.impl.classfile.ClassFileFieldBuilder;
import net.lenni0451.reflect.bytecode.impl.classfile.ClassFileMethodBuilder;

public class ClassFileClassBuilder
implements net.lenni0451.reflect.bytecode.builder.ClassBuilder {
    private final String name;
    private final ClassBuilder classBuilder;

    public ClassFileClassBuilder(String name, ClassBuilder classBuilder) {
        this.name = name;
        this.classBuilder = classBuilder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void field(int access, String name, String descriptor, String signature, Object defaultValue, Consumer<FieldBuilder> consumer) {
        this.classBuilder.withField(name, ClassDesc.ofDescriptor(descriptor), fieldBuilder -> {
            fieldBuilder.withFlags(access);
            if (signature != null) {
                fieldBuilder.with((ClassFileElement)SignatureAttribute.of((Signature)Signature.parseFrom((String)signature)));
            }
            if (defaultValue != null) {
                Object object = defaultValue;
                Objects.requireNonNull(object);
                Object selector0$temp = object;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        Boolean b = (Boolean)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().intEntry(b != false ? 1 : 0)));
                        break;
                    }
                    case 1: {
                        Byte b = (Byte)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().intEntry((int)b.byteValue())));
                        break;
                    }
                    case 2: {
                        Short s = (Short)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().intEntry((int)s.shortValue())));
                        break;
                    }
                    case 3: {
                        Character c = (Character)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().intEntry((int)c.charValue())));
                        break;
                    }
                    case 4: {
                        Integer i = (Integer)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().intEntry(i.intValue())));
                        break;
                    }
                    case 5: {
                        Long l = (Long)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().longEntry(l.longValue())));
                        break;
                    }
                    case 6: {
                        Float f = (Float)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().floatEntry(f.floatValue())));
                        break;
                    }
                    case 7: {
                        Double d = (Double)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().doubleEntry(d.doubleValue())));
                        break;
                    }
                    case 8: {
                        String s = (String)selector0$temp;
                        fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantValueEntry)this.classBuilder.constantPool().stringEntry(s)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported constant value type: " + defaultValue.getClass().getName());
                    }
                }
            }
            consumer.accept(new ClassFileFieldBuilder((java.lang.classfile.FieldBuilder)fieldBuilder));
        });
    }

    @Override
    public void method(int access, String name, String descriptor, String signature, String[] exceptions, Consumer<MethodBuilder> consumer) {
        this.classBuilder.withMethod(name, MethodTypeDesc.ofDescriptor(descriptor), access, methodBuilder -> {
            if (signature != null) {
                methodBuilder.with((ClassFileElement)SignatureAttribute.of((MethodSignature)MethodSignature.parseFrom((String)signature)));
            }
            if (exceptions != null && exceptions.length > 0) {
                ClassDesc[] exceptionDescs = new ClassDesc[exceptions.length];
                for (int i = 0; i < exceptions.length; ++i) {
                    exceptionDescs[i] = ClassDesc.ofInternalName(exceptions[i]);
                }
                methodBuilder.with((ClassFileElement)ExceptionsAttribute.ofSymbols((ClassDesc[])exceptionDescs));
            }
            methodBuilder.withCode(codeBuilder -> consumer.accept(new ClassFileMethodBuilder((CodeBuilder)codeBuilder)));
        });
    }

    @Generated
    public ClassBuilder getClassBuilder() {
        return this.classBuilder;
    }
}

