/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import net.lenni0451.reflect.Fields;
import net.lenni0451.reflect.JVMConstants;
import net.lenni0451.reflect.accessor.UnsafeAccess;
import net.lenni0451.reflect.exceptions.InvalidOOPSizeException;
import net.lenni0451.reflect.utils.FieldInitializer;

public class Objects {
    public static final long BOOLEAN_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(boolean[].class);
    public static final int BOOLEAN_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(boolean[].class);
    public static final long BYTE_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(byte[].class);
    public static final int BYTE_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(byte[].class);
    public static final long SHORT_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(short[].class);
    public static final int SHORT_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(short[].class);
    public static final long CHAR_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(char[].class);
    public static final int CHAR_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(char[].class);
    public static final long INT_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(int[].class);
    public static final int INT_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(int[].class);
    public static final long LONG_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(long[].class);
    public static final int LONG_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(long[].class);
    public static final long FLOAT_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(float[].class);
    public static final int FLOAT_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(float[].class);
    public static final long DOUBLE_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(double[].class);
    public static final int DOUBLE_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(double[].class);
    public static final long OBJECT_ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(Object[].class);
    public static final int OBJECT_ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(Object[].class);
    private static final ThreadLocal<Object[]> OBJECT_ARRAY_CACHE = ThreadLocal.withInitial(() -> new Object[1]);
    public static final int ADDRESS_SIZE = UnsafeAccess.addressSize();
    public static final int OOP_SIZE = CompressedOopsClass.access$000();
    public static final int OBJECT_HEADER_SIZE = BooleanHeaderClass.access$100();
    public static final int OBJECT_ALIGNMENT = FieldInitializer.init(() -> {
        HotSpotDiagnosticMXBean mxBean;
        if (!JVMConstants.OPENJ9_RUNTIME && (mxBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class)) != null) {
            return Integer.parseInt(mxBean.getVMOption(JVMConstants.VM_OPTION_ObjectAlignmentInBytes).getValue());
        }
        return 8;
    });
    public static final boolean COMPRESSED_OOPS = ADDRESS_SIZE != OOP_SIZE;
    public static final int COMPRESSED_OOP_SHIFT = FieldInitializer.init(() -> {
        int i = OBJECT_ALIGNMENT;
        int result = 0;
        while ((i >>= 1) != 0) {
            ++result;
        }
        return result;
    });
    public static final long COMPRESSED_OOP_BASE = 0L;
    public static final long KLASS_OFFSET = JVMConstants.OPENJ9_RUNTIME ? 0L : (long)(OBJECT_HEADER_SIZE - OOP_SIZE);

    @Deprecated
    public static long toAddress(Object o) {
        return Objects.toJVMAddress(o);
    }

    public static long toJVMAddress(Object o) {
        long jvmAddress;
        Object[] array = OBJECT_ARRAY_CACHE.get();
        array[0] = o;
        if (OOP_SIZE == 4) {
            jvmAddress = (long)UnsafeAccess.getInt(array, OBJECT_ARRAY_BASE_OFFSET) & 0xFFFFFFFFL;
        } else if (OOP_SIZE == 8) {
            jvmAddress = UnsafeAccess.getLong(array, OBJECT_ARRAY_BASE_OFFSET);
        } else {
            throw new InvalidOOPSizeException();
        }
        array[0] = null;
        return jvmAddress;
    }

    public static long toJVMAddress(long nativeAddress) {
        if (COMPRESSED_OOPS) {
            return nativeAddress - 0L >>> COMPRESSED_OOP_SHIFT;
        }
        return nativeAddress;
    }

    public static long toNativeAddress(Object o) {
        return Objects.toNativeAddress(Objects.toJVMAddress(o));
    }

    public static long toNativeAddress(long jvmAddress) {
        if (COMPRESSED_OOPS) {
            return 0L + (jvmAddress << COMPRESSED_OOP_SHIFT);
        }
        return jvmAddress;
    }

    @Deprecated
    public static <T> T fromAddress(long jvmAddress) {
        return Objects.fromJVMAddress(jvmAddress);
    }

    public static <T> T fromJVMAddress(long jvmAddress) {
        Object[] array = OBJECT_ARRAY_CACHE.get();
        if (OOP_SIZE == 4) {
            UnsafeAccess.putInt(array, OBJECT_ARRAY_BASE_OFFSET, (int)jvmAddress);
        } else if (OOP_SIZE == 8) {
            UnsafeAccess.putLong(array, OBJECT_ARRAY_BASE_OFFSET, jvmAddress);
        } else {
            throw new InvalidOOPSizeException();
        }
        Object o = array[0];
        array[0] = null;
        return (T)o;
    }

    public static void copyMemory(Object from, Object to, long size) {
        Objects.copyMemory(from, 0L, to, 0L, size);
    }

    public static void copyMemory(Object from, long fromOffset, Object to, long toOffset, long size) {
        UnsafeAccess.copyMemory(Objects.toJVMAddress(from) + fromOffset, Objects.toJVMAddress(to) + toOffset, size);
    }

    public static long getKlass(Class<?> clazz) {
        if (clazz.isArray()) {
            return Objects.getKlass(Array.newInstance(clazz.getComponentType(), 0));
        }
        return Objects.getKlass(UnsafeAccess.allocateInstance(clazz));
    }

    public static long getKlass(Object o) {
        if (OOP_SIZE == 4) {
            return (long)UnsafeAccess.getInt(o, KLASS_OFFSET) & 0xFFFFFFFFL;
        }
        if (OOP_SIZE == 8) {
            return UnsafeAccess.getLong(o, KLASS_OFFSET);
        }
        throw new InvalidOOPSizeException();
    }

    public static <T> T cast(Object o, Class<T> target) {
        return Objects.cast(o, Objects.getKlass(target));
    }

    public static <T> T cast(Object o, Object target) {
        return Objects.cast(o, Objects.getKlass(target));
    }

    public static <T> T cast(Object o, long klass) {
        if (OOP_SIZE == 4) {
            UnsafeAccess.putInt(o, KLASS_OFFSET, (int)klass);
        } else if (OOP_SIZE == 8) {
            UnsafeAccess.putLong(o, KLASS_OFFSET, klass);
        } else {
            throw new InvalidOOPSizeException();
        }
        return (T)o;
    }

    public static <T> T allocate(Class<T> clazz) {
        return (T)UnsafeAccess.allocateInstance(clazz);
    }

    private static class BooleanHeaderClass {
        public boolean b;

        private BooleanHeaderClass() {
        }

        private static int getHeaderSize() {
            long b = UnsafeAccess.objectFieldOffset(Fields.getDeclaredField(BooleanHeaderClass.class, "b"));
            return (int)b;
        }

        static /* synthetic */ int access$100() {
            return BooleanHeaderClass.getHeaderSize();
        }
    }

    private static class CompressedOopsClass {
        public Object o1;
        public Object o2;

        private CompressedOopsClass() {
        }

        private static int getOopSize() {
            long o1 = UnsafeAccess.objectFieldOffset(Fields.getDeclaredField(CompressedOopsClass.class, "o1"));
            long o2 = UnsafeAccess.objectFieldOffset(Fields.getDeclaredField(CompressedOopsClass.class, "o2"));
            return (int)Math.abs(o2 - o1);
        }

        static /* synthetic */ int access$000() {
            return CompressedOopsClass.getOopSize();
        }
    }
}

