/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.reflect.Fields;
import net.lenni0451.reflect.bytecode.BytecodeUtils;
import net.lenni0451.reflect.bytecode.builder.BytecodeBuilder;
import net.lenni0451.reflect.bytecode.builder.ClassBuilder;
import net.lenni0451.reflect.bytecode.wrapper.BuiltClass;
import net.lenni0451.reflect.bytecode.wrapper.BytecodeLabel;
import net.lenni0451.reflect.proxy.InvocationHandler;
import net.lenni0451.reflect.proxy.ProxyClass;
import net.lenni0451.reflect.proxy.ProxyClassDefiner;
import net.lenni0451.reflect.proxy.impl.Proxy;
import net.lenni0451.reflect.proxy.impl.ProxyMethod;
import net.lenni0451.reflect.proxy.impl.ProxyRuntime;
import net.lenni0451.reflect.proxy.internal.ProxyMethodBuilder;
import net.lenni0451.reflect.proxy.internal.ProxyUtils;

public class ProxyBuilder {
    private static final BytecodeBuilder BUILDER = BytecodeBuilder.get();
    private static final String METHODS_FIELD = "METHODS";
    private static final String PROXY_METHOD_CLASSES_FIELD = "PROXY_METHOD_CLASSES";
    private static final String INVOCATION_HANDLER_FIELD = "invocationHandler";
    @Nullable
    private Class<?> superClass;
    @Nullable
    private Class<?>[] interfaces;
    private Predicate<Method> methodFilter = m -> true;
    private Function<Method, Method> methodMapper = Function.identity();
    private InvocationHandler invocationHandler = InvocationHandler.forwarding();
    private ProxyClassDefiner classDefiner = ProxyClassDefiner.loader(ProxyBuilder.class.getClassLoader());
    private Class<?> proxyClass;

    @Nullable
    public Class<?> getSuperClass() {
        return this.superClass;
    }

    public ProxyBuilder setSuperClass(@Nullable Class<?> superClass) {
        if (superClass != null) {
            ProxyUtils.verifySuperClass(superClass);
        }
        this.reset();
        this.superClass = superClass;
        return this;
    }

    @Nullable
    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    public ProxyBuilder addInterface(@Nonnull Class<?> clazz) {
        ProxyUtils.verifyInterface(clazz);
        this.reset();
        if (this.interfaces == null) {
            this.interfaces = new Class[]{clazz};
        } else {
            this.interfaces = Arrays.copyOf(this.interfaces, this.interfaces.length + 1);
            this.interfaces[this.interfaces.length - 1] = clazz;
        }
        return this;
    }

    public ProxyBuilder setInterfaces(Class<?> ... interfaces) {
        if (interfaces != null) {
            for (Class<?> inter : interfaces) {
                ProxyUtils.verifyInterface(inter);
            }
        }
        this.reset();
        this.interfaces = interfaces;
        return this;
    }

    public Predicate<Method> getMethodFilter() {
        return this.methodFilter;
    }

    public ProxyBuilder setMethodFilter(@Nonnull Predicate<Method> methodFilter) {
        this.reset();
        this.methodFilter = methodFilter;
        return this;
    }

    public Function<Method, Method> getMethodMapper() {
        return this.methodMapper;
    }

    public ProxyBuilder setMethodMapper(@Nonnull Function<Method, Method> methodMapper) {
        this.reset();
        this.methodMapper = methodMapper;
        return this;
    }

    public InvocationHandler getInvocationHandler() {
        return this.invocationHandler;
    }

    public ProxyBuilder setInvocationHandler(@Nonnull InvocationHandler invocationHandler) {
        this.reset();
        this.invocationHandler = invocationHandler;
        return this;
    }

    public ProxyClassDefiner getClassDefiner() {
        return this.classDefiner;
    }

    public ProxyBuilder setClassDefiner(@Nonnull ProxyClassDefiner classDefiner) {
        this.reset();
        this.classDefiner = classDefiner;
        return this;
    }

    public ProxyClass build() {
        if (this.proxyClass == null) {
            Reference<Method[]> methodsReference = new Reference<Method[]>();
            Reference<Method[]> originalMethodsReference = new Reference<Method[]>();
            BuiltClass builtClass = this.buildClass(methodsReference, originalMethodsReference);
            this.proxyClass = this.classDefiner.defineProxyClass(builtClass, this.superClass, this.interfaces);
            Field methods = Fields.getDeclaredField(this.proxyClass, METHODS_FIELD);
            Fields.setObject(null, methods, ((Reference)methodsReference).value);
            Class<ProxyMethod>[] proxyMethodClasses = this.buildProxyMethodClasses((Method[])((Reference)methodsReference).value, (Method[])((Reference)originalMethodsReference).value);
            Field proxyMethodClassesField = Fields.getDeclaredField(this.proxyClass, PROXY_METHOD_CLASSES_FIELD);
            Fields.setObject(null, proxyMethodClassesField, proxyMethodClasses);
        }
        return new ProxyClass(this.proxyClass, this.invocationHandler);
    }

    private BuiltClass buildClass(Reference<Method[]> methodsReference, Reference<Method[]> originalMethodsReference) {
        String className = "net/lenni0451/reflect/proxy/ProxyImpl$" + System.nanoTime();
        Class<?>[] interfaces = this.interfaces;
        if (interfaces == null) {
            interfaces = new Class[]{Proxy.class};
        } else {
            interfaces = Arrays.copyOf(interfaces, interfaces.length + 1);
            interfaces[interfaces.length - 1] = Proxy.class;
        }
        return BUILDER.class_(BUILDER.opcode("ACC_PUBLIC"), className, null, this.superClass == null ? BytecodeUtils.slash(Object.class) : BytecodeUtils.slash(this.superClass), (String[])Arrays.stream(interfaces).map(BytecodeUtils::slash).toArray(String[]::new), cb -> {
            this.addConstructors((ClassBuilder)cb);
            Method[] methods = ProxyUtils.getOverridableMethod(this.superClass, this.interfaces, this.methodFilter);
            ((Reference)methodsReference).value = methods;
            ((Reference)originalMethodsReference).value = ProxyUtils.mapMethods(methods, this.methodMapper);
            this.addFields((ClassBuilder)cb, methods);
            this.addMethods((ClassBuilder)cb, methods);
            this.addDefaultMethods((ClassBuilder)cb);
        });
    }

    private void addConstructors(ClassBuilder cb) {
        if (this.superClass == null) {
            cb.method(BUILDER.opcode("ACC_PUBLIC"), "<init>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), null, null, mb -> mb.aload(0).invokespecial(BytecodeUtils.slash(Object.class), "<init>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), false).return_().maxs(1, 1));
        } else {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = ProxyUtils.getPublicConstructors(this.superClass)) {
                cb.method(BUILDER.opcode("ACC_PUBLIC"), "<init>", BytecodeUtils.mdesc(Void.TYPE, constructor.getParameterTypes()), null, null, mb -> {
                    mb.aload(0);
                    int index = 1;
                    for (Class<?> parameter : constructor.getParameterTypes()) {
                        mb.load(parameter, index);
                        index += BytecodeUtils.getStackSize(parameter);
                    }
                    mb.invokespecial(BytecodeUtils.slash(this.superClass), "<init>", BytecodeUtils.mdesc(Void.TYPE, constructor.getParameterTypes()), false).return_().maxs(index, index);
                });
            }
        }
    }

    private void addFields(ClassBuilder cb, Method[] methods) {
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_STATIC", "ACC_FINAL"), METHODS_FIELD, BytecodeUtils.desc(Method[].class), null, null);
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_STATIC", "ACC_FINAL"), PROXY_METHOD_CLASSES_FIELD, BytecodeUtils.desc(Class[].class), null, null);
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_FINAL"), INVOCATION_HANDLER_FIELD, BytecodeUtils.desc(InvocationHandler.class), null, null);
        for (int i = 0; i < methods.length; ++i) {
            cb.field(BUILDER.opcode("ACC_PRIVATE"), "method" + i, BytecodeUtils.desc(ProxyMethod.class), null, null);
        }
    }

    private void addMethods(ClassBuilder cb, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            int methodId = i;
            Method method = methods[i];
            cb.method(BUILDER.opcode("ACC_PUBLIC"), method.getName(), BytecodeUtils.desc(method), null, null, mb -> {
                BytecodeLabel elseLabel = mb.newLabel();
                mb.aload(0).getfield(cb.getName(), INVOCATION_HANDLER_FIELD, BytecodeUtils.desc(InvocationHandler.class)).aload(0).dup().getfield(cb.getName(), "method" + methodId, BytecodeUtils.desc(ProxyMethod.class)).dup().ifnonnull(elseLabel).pop();
                mb.aload(0).getstatic(cb.getName(), PROXY_METHOD_CLASSES_FIELD, BytecodeUtils.desc(Class[].class)).intPush(methodId).aaload().aload(0).getstatic(cb.getName(), METHODS_FIELD, BytecodeUtils.desc(Method[].class)).intPush(methodId).aaload().invokestatic(BytecodeUtils.slash(ProxyRuntime.class), "instantiateProxyMethod", BytecodeUtils.mdesc(ProxyMethod.class, Class.class, Object.class, Method.class), false).dupX1().putfield(cb.getName(), "method" + methodId, BytecodeUtils.desc(ProxyMethod.class));
                mb.label(elseLabel).intPush(method.getParameterCount()).anewarray(BytecodeUtils.slash(Object.class));
                int paramVarIndex = 1;
                for (int param = 0; param < method.getParameterCount(); ++param) {
                    Class<?> parameter = method.getParameterTypes()[param];
                    mb.dup().intPush(param).load(parameter, paramVarIndex).box(parameter).aastore();
                    paramVarIndex += BytecodeUtils.getStackSize(parameter);
                }
                mb.invokeinterface(BytecodeUtils.slash(InvocationHandler.class), "invoke", BytecodeUtils.mdesc(Object.class, Object.class, ProxyMethod.class, Object[].class));
                if (method.getReturnType() == Void.TYPE) {
                    mb.pop();
                } else {
                    mb.checkcast(BytecodeUtils.slash(BytecodeUtils.boxed(method.getReturnType()))).unbox(method.getReturnType());
                }
                mb.return_(method.getReturnType()).maxs(paramVarIndex, 1);
            });
        }
    }

    private void addDefaultMethods(ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "setInvocationHandler", BytecodeUtils.mdesc(Void.TYPE, InvocationHandler.class), null, null, mb -> mb.aload(0).aload(1).putfield(cb.getName(), INVOCATION_HANDLER_FIELD, BytecodeUtils.desc(InvocationHandler.class)).return_().maxs(2, 2));
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "getInvocationHandler", BytecodeUtils.mdesc(InvocationHandler.class, new Class[0]), null, null, mb -> mb.aload(0).getfield(cb.getName(), INVOCATION_HANDLER_FIELD, BytecodeUtils.desc(InvocationHandler.class)).areturn().maxs(1, 1));
    }

    private Class<ProxyMethod>[] buildProxyMethodClasses(Method[] methods, Method[] originalMethods) {
        Class[] proxyMethodClasses = new Class[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            proxyMethodClasses[i] = ProxyMethodBuilder.buildProxyMethodClass(this.proxyClass, methods[i], originalMethods[i]);
        }
        return proxyMethodClasses;
    }

    private void reset() {
        this.proxyClass = null;
    }

    private static class Reference<T> {
        private T value;

        private Reference() {
        }
    }
}

