/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.additionalclassprovider;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.tree.IClassProvider;

@ParametersAreNonnullByDefault
public class LazyFileClassProvider
implements IClassProvider,
AutoCloseable {
    @Nullable
    private final IClassProvider parent;
    private final LazyLoader[] loaders;

    public LazyFileClassProvider(Collection<File> files) {
        this(null, files);
    }

    public LazyFileClassProvider(Collection<File> files, @Nullable IClassProvider parent) {
        this(parent, files);
    }

    public LazyFileClassProvider(@Nullable IClassProvider parent, Collection<File> files) {
        this.parent = parent;
        this.loaders = new LazyLoader[files.size()];
        int i = 0;
        for (File file : files) {
            this.loaders[i++] = new LazyLoader(file);
        }
    }

    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        for (LazyLoader loader : this.loaders) {
            try {
                return loader.getClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (this.parent != null) {
            return this.parent.getClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    @Nonnull
    public Map<String, Supplier<byte[]>> getAllClasses() {
        if (this.parent == null) {
            return Collections.emptyMap();
        }
        return this.parent.getAllClasses();
    }

    @Override
    public void close() throws Exception {
        for (LazyLoader loader : this.loaders) {
            loader.close();
        }
    }

    private static class LazyLoader
    implements AutoCloseable {
        private final File file;
        private FileSystem fileSystem;
        private Path root;

        private LazyLoader(File file) {
            this.file = file;
        }

        private void open() {
            URI uri = new URI("jar:" + this.file.toURI());
            try {
                this.fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException e) {
                this.fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            }
            this.root = this.fileSystem.getRootDirectories().iterator().next();
        }

        private byte[] getClass(String name) throws ClassNotFoundException {
            if (this.fileSystem == null) {
                this.open();
            }
            try {
                Path path = this.root.resolve(ASMUtils.slash((String)name) + ".class");
                if (Files.exists(path, new LinkOption[0])) {
                    return Files.readAllBytes(path);
                }
            }
            catch (Throwable t) {
                throw new ClassNotFoundException(name, t);
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public void close() throws Exception {
            if (this.fileSystem != null) {
                this.fileSystem.close();
                this.fileSystem = null;
            }
        }
    }
}

