/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.debugger.timings.TimedTransformer;
import net.lenni0451.classtransform.utils.log.Logger;

@ParametersAreNonnullByDefault
public class TransformerDebugger {
    private final TransformerManager transformerManager;
    private final Map<String, Map<TimedTransformer, Integer>> timings;
    private boolean dumpClasses = System.getProperty("classtransform.dumpClasses") != null;

    TransformerDebugger(TransformerManager transformerManager) {
        this.transformerManager = transformerManager;
        this.timings = new ConcurrentHashMap<String, Map<TimedTransformer, Integer>>();
    }

    public void loadTransformedClasses() {
        this.loadTransformedClasses(this.getClass().getClassLoader());
    }

    public void loadTransformedClasses(ClassLoader classLoader) {
        for (String transformedClass : this.transformerManager.getTransformedClasses().toArray(new String[0])) {
            try {
                Class<?> clazz = classLoader.loadClass(transformedClass);
                Logger.info("Loaded transformed class {}", clazz.getName());
            }
            catch (Throwable t) {
                Logger.error("Failed to load transformed class {}", transformedClass, t);
            }
        }
    }

    public Map<String, Map<TimedTransformer, Integer>> getTimings() {
        return Collections.unmodifiableMap(this.timings);
    }

    public void setDumpClasses(boolean dumpClasses) {
        this.dumpClasses = dumpClasses;
    }

    public boolean isDumpClasses() {
        return this.dumpClasses;
    }

    public void clearTransformerManager() {
        this.transformerManager.bytecodeTransformer.clear();
        this.transformerManager.rawTransformer.clear();
        this.transformerManager.transformer.clear();
        this.transformerManager.postTransformer.clear();
        this.transformerManager.registeredTransformer.clear();
        this.transformerManager.transformedClasses.clear();
    }

    void addTimings(String className, Map<TimedTransformer, Integer> timings) {
        if (!timings.isEmpty()) {
            this.timings.put(className, timings);
        }
    }
}

