/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.coprocessor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.transformer.IAnnotationCoprocessor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AnnotationCoprocessorList {
    private final List<Supplier<? extends IAnnotationCoprocessor>> coprocessorSupplier;
    private final List<IAnnotationCoprocessor> coprocessors;
    private State state;

    public AnnotationCoprocessorList() {
        this(new ArrayList<Supplier<? extends IAnnotationCoprocessor>>(), null, State.OPEN);
    }

    private AnnotationCoprocessorList(List<Supplier<? extends IAnnotationCoprocessor>> coprocessorSupplier, List<IAnnotationCoprocessor> coprocessors, State state) {
        this.coprocessorSupplier = coprocessorSupplier;
        this.coprocessors = coprocessors;
        this.state = state;
    }

    private void expect(State expected) {
        this.expect(expected, expected);
    }

    private void expect(State expected, State newState) {
        if (!this.state.equals((Object)expected)) {
            throw new IllegalStateException("Expected state " + expected.name() + " but got " + this.state.name());
        }
        this.state = newState;
    }

    public void add(Supplier<? extends IAnnotationCoprocessor> coprocessorSupplier) {
        this.expect(State.OPEN);
        this.coprocessorSupplier.add(coprocessorSupplier);
    }

    public AnnotationCoprocessorList build() {
        this.expect(State.OPEN);
        AnnotationCoprocessorList list = new AnnotationCoprocessorList(null, new ArrayList<IAnnotationCoprocessor>(), State.BUILT);
        for (Supplier<? extends IAnnotationCoprocessor> supplier : this.coprocessorSupplier) {
            list.coprocessors.add(supplier.get());
        }
        return list;
    }

    public MethodNode preprocess(TransformerManager transformerManager, ClassNode transformedClass, MethodNode transformedMethod, ClassNode transformer, MethodNode transformerMethod) {
        this.expect(State.BUILT, State.USED);
        for (IAnnotationCoprocessor coprocessor : this.coprocessors) {
            transformerMethod = coprocessor.preprocess(transformerManager, transformedClass, transformedMethod, transformer, transformerMethod);
        }
        for (int i = this.coprocessors.size() - 1; i >= 0; --i) {
            IAnnotationCoprocessor coprocessor;
            coprocessor = this.coprocessors.get(i);
            transformerMethod = coprocessor.transform(transformerManager, transformedClass, transformedMethod, transformer, transformerMethod);
        }
        return transformerMethod;
    }

    public void postprocess(TransformerManager transformerManager, ClassNode transformedClass, MethodNode transformedMethod, List<MethodInsnNode> transformerMethodCalls, ClassNode transformer, MethodNode transformerMethod) {
        this.expect(State.USED, State.CLOSED);
        for (IAnnotationCoprocessor coprocessor : this.coprocessors) {
            coprocessor.postprocess(transformerManager, transformedClass, transformedMethod, transformerMethodCalls, transformer, transformerMethod);
        }
    }

    private static enum State {
        OPEN,
        BUILT,
        USED,
        CLOSED;

    }
}

