/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.impl.redirect;

import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.exceptions.TransformerException;
import net.lenni0451.classtransform.transformer.impl.redirect.IRedirectTarget;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.Codifier;
import net.lenni0451.classtransform.utils.Types;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@ParametersAreNonnullByDefault
public class CRedirectInvoke
implements IRedirectTarget {
    @Override
    public void inject(ClassNode targetClass, MethodNode targetMethod, ClassNode transformer, MethodNode transformerMethod, AbstractInsnNode targetNode, List<MethodInsnNode> transformerMethodCalls) {
        MethodInsnNode transformerCall;
        boolean cast;
        MethodInsnNode methodInsnNode = (MethodInsnNode)targetNode;
        Type returnType = Types.returnType(transformerMethod.desc);
        Type[] argumentTypes = Types.argumentTypes(transformerMethod.desc);
        Type originalReturnType = Types.returnType(methodInsnNode.desc);
        Type[] originalArgumentTypes = Types.argumentTypes(methodInsnNode.desc);
        if (!ASMUtils.compareType(originalReturnType, returnType)) {
            throw new TransformerException(transformerMethod, transformer, "does not have same return type as original invoke").help(Codifier.of(transformerMethod).returnType(originalReturnType).param(null).params(originalArgumentTypes));
        }
        boolean bl = cast = !originalReturnType.equals((Object)returnType);
        if (methodInsnNode.getOpcode() == 184) {
            if (!ASMUtils.compareTypes(originalArgumentTypes, argumentTypes)) {
                throw new TransformerException(transformerMethod, transformer, "does not have same argument types as original invoke").help(Codifier.of(transformerMethod).param(null).params(originalArgumentTypes));
            }
        } else if (!ASMUtils.compareTypes(originalArgumentTypes, argumentTypes, true, Types.type(methodInsnNode.owner))) {
            throw new TransformerException(transformerMethod, transformer, "does not have same argument types as original invoke with instance").help(Codifier.of(transformerMethod).param(null).params(Types.type(methodInsnNode.owner)).params(originalArgumentTypes));
        }
        int freeVarIndex = ASMUtils.getFreeVarIndex(targetMethod);
        InsnList[] loadStoreOpcodes = this.getLoadStoreOpcodes(methodInsnNode.getOpcode() == 184 ? null : methodInsnNode.owner, methodInsnNode.desc, freeVarIndex);
        InsnList storeOpcodes = loadStoreOpcodes[0];
        InsnList loadOpcodes = loadStoreOpcodes[1];
        if (cast) {
            targetMethod.instructions.insert((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new TypeInsnNode(192, Types.returnType(methodInsnNode.desc).getInternalName()));
        }
        if (!Modifier.isStatic(transformerMethod.access)) {
            targetMethod.instructions.insertBefore((AbstractInsnNode)methodInsnNode, storeOpcodes);
            targetMethod.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
            targetMethod.instructions.insertBefore((AbstractInsnNode)methodInsnNode, loadOpcodes);
            transformerCall = new MethodInsnNode(Modifier.isInterface(targetClass.access) ? 185 : 182, targetClass.name, transformerMethod.name, transformerMethod.desc);
        } else {
            transformerCall = new MethodInsnNode(184, targetClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(targetClass.access));
        }
        targetMethod.instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)transformerCall);
        transformerMethodCalls.add(transformerCall);
    }
}

