/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.utils;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.utils.MemberDeclaration;
import net.lenni0451.classtransform.utils.Types;
import net.lenni0451.classtransform.utils.tree.ClassTree;
import net.lenni0451.classtransform.utils.tree.IClassProvider;
import net.lenni0451.classtransform.utils.tree.TreeClassWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@ParametersAreNonnullByDefault
public class ASMUtils {
    public static final String METHOD_DECLARATION_PATTERN = "^(?>L([^;]+);|([^.]+)\\.)([^(]+)(\\([^)]*\\).+)$";
    public static final String FIELD_DECLARATION_PATTERN = "^(?>L([^;]+);|([^.]+)\\.)([^(]+):(.+)$";

    public static ClassNode fromBytes(byte[] bytecode) {
        return ASMUtils.fromBytes(bytecode, 8);
    }

    public static ClassNode fromBytes(byte[] bytecode, int flags) {
        ClassNode node = new ClassNode();
        new ClassReader(bytecode).accept((ClassVisitor)node, flags);
        return node;
    }

    public static byte[] toBytes(ClassNode node, TransformerManager transformerManager) {
        return ASMUtils.toBytes(node, transformerManager.getClassTree(), transformerManager.getClassProvider());
    }

    public static byte[] toBytes(ClassNode node, ClassTree classTree, IClassProvider classProvider) {
        TreeClassWriter writer = new TreeClassWriter(classTree, classProvider);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] toBytes(ClassNode node, TransformerManager transformerManager, int flags) {
        return ASMUtils.toBytes(node, transformerManager.getClassTree(), transformerManager.getClassProvider(), flags);
    }

    public static byte[] toBytes(ClassNode node, ClassTree classTree, IClassProvider classProvider, int flags) {
        TreeClassWriter writer = new TreeClassWriter(flags, classTree, classProvider);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] toStacklessBytes(ClassNode node) {
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    @Nullable
    public static MethodNode getMethod(ClassNode classNode, String name, String desc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(name) || !method.desc.equals(desc)) continue;
            return method;
        }
        return null;
    }

    public static boolean hasMethod(ClassNode classNode, String name, String desc) {
        return ASMUtils.getMethod(classNode, name, desc) != null;
    }

    @Nullable
    public static FieldNode getField(ClassNode classNode, String name, String desc) {
        for (FieldNode field : classNode.fields) {
            if (!field.name.equals(name)) continue;
            return field;
        }
        return null;
    }

    public static boolean hasField(ClassNode classNode, String name, String desc) {
        return ASMUtils.getField(classNode, name, desc) != null;
    }

    public static List<MethodNode> getMethodsFromCombi(ClassNode classNode, String combi) {
        if (combi.isEmpty()) {
            throw new IllegalArgumentException("Combi cannot be empty");
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        if (combi.contains("(")) {
            String desc;
            String name = combi.substring(0, combi.indexOf("("));
            MethodNode method2 = ASMUtils.getMethod(classNode, name, desc = combi.substring(combi.indexOf("(")));
            if (method2 != null) {
                methods.add(method2);
            }
        } else {
            String regex = ASMUtils.combiToRegex(combi);
            for (MethodNode method3 : classNode.methods) {
                if (!method3.name.matches(regex)) continue;
                methods.add(method3);
            }
            if (methods.size() > 1 && methods.stream().anyMatch(method -> (method.access & 0x1000) == 0)) {
                methods.removeIf(method -> (method.access & 0x1000) != 0);
            }
        }
        return methods;
    }

    public static List<FieldNode> getFieldsFromCombi(ClassNode classNode, String combi) {
        if (combi.isEmpty()) {
            throw new IllegalArgumentException("Combi cannot be empty");
        }
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
        if (combi.contains(":")) {
            String desc;
            String name = combi.substring(0, combi.indexOf(":"));
            FieldNode field = ASMUtils.getField(classNode, name, desc = combi.substring(combi.indexOf(":") + 1));
            if (field != null) {
                fields.add(field);
            }
        } else {
            String regex = ASMUtils.combiToRegex(combi);
            for (FieldNode field : classNode.fields) {
                if (!field.name.matches(regex)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static String combiToRegex(String combi) {
        if (combi.replace("*", "").isEmpty()) {
            return ".*";
        }
        if (combi.contains("*")) {
            boolean startsWith = combi.startsWith("*");
            boolean endsWith = combi.endsWith("*");
            while (combi.startsWith("*")) {
                combi = combi.substring(1);
            }
            while (combi.endsWith("*")) {
                combi = combi.substring(0, combi.length() - 1);
            }
            while (combi.contains("**")) {
                combi = combi.replace("**", "*");
            }
            String[] parts = combi.split("\\*");
            combi = "^";
            if (startsWith) {
                combi = combi + ".*";
            }
            for (int i = 0; i < parts.length; ++i) {
                combi = combi + Pattern.quote(parts[i]) + (i == parts.length - 1 ? "" : ".*");
            }
            if (endsWith) {
                combi = combi + ".*";
            }
            combi = combi + "$";
            return combi;
        }
        return Pattern.quote(combi);
    }

    public static boolean isAccessLower(int toCheck, int checkAgainst) {
        int rank1 = (toCheck & 1) != 0 ? 4 : ((toCheck & 4) != 0 ? 3 : ((toCheck & 2) == 0 ? 2 : 1));
        int rank2 = (checkAgainst & 1) != 0 ? 4 : ((checkAgainst & 4) != 0 ? 3 : ((checkAgainst & 2) == 0 ? 2 : 1));
        return rank1 < rank2;
    }

    public static int setAccess(int currentAccess, int newAccess) {
        int access = currentAccess;
        access &= 0xFFFFFFFD;
        access &= 0xFFFFFFFB;
        access &= 0xFFFFFFFE;
        return access |= newAccess;
    }

    public static int setModifier(int currentAccess, int modifier, boolean value) {
        return value ? currentAccess | modifier : currentAccess & ~modifier;
    }

    public static int getReturnOpcode(Type returnType) {
        if (returnType.equals((Object)Type.VOID_TYPE)) {
            return 177;
        }
        if (returnType.equals((Object)Type.BOOLEAN_TYPE)) {
            return 172;
        }
        if (returnType.equals((Object)Type.BYTE_TYPE)) {
            return 172;
        }
        if (returnType.equals((Object)Type.CHAR_TYPE)) {
            return 172;
        }
        if (returnType.equals((Object)Type.SHORT_TYPE)) {
            return 172;
        }
        if (returnType.equals((Object)Type.INT_TYPE)) {
            return 172;
        }
        if (returnType.equals((Object)Type.FLOAT_TYPE)) {
            return 174;
        }
        if (returnType.equals((Object)Type.LONG_TYPE)) {
            return 173;
        }
        if (returnType.equals((Object)Type.DOUBLE_TYPE)) {
            return 175;
        }
        return 176;
    }

    public static int getLoadOpcode(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return 23;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return 22;
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return 24;
        }
        return 25;
    }

    public static int getStoreOpcode(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return 56;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return 55;
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return 57;
        }
        return 58;
    }

    public static int getFreeVarIndex(MethodNode methodNode) {
        int currentIndex = 0;
        if (!Modifier.isStatic(methodNode.access)) {
            currentIndex = 1;
        }
        for (Type arg : Type.getArgumentTypes((String)methodNode.desc)) {
            currentIndex += arg.getSize();
        }
        for (AbstractInsnNode instruction : methodNode.instructions) {
            if (instruction.getOpcode() >= 54 && instruction.getOpcode() <= 58 || instruction.getOpcode() >= 21 && instruction.getOpcode() <= 25) {
                VarInsnNode varInsnNode = (VarInsnNode)instruction;
                if (varInsnNode.var <= currentIndex) continue;
                currentIndex = varInsnNode.var;
                continue;
            }
            if (instruction.getOpcode() != 132) continue;
            IincInsnNode iincInsnNode = (IincInsnNode)instruction;
            if (iincInsnNode.var <= currentIndex) continue;
            currentIndex = iincInsnNode.var;
        }
        return currentIndex + 2;
    }

    public static InsnList getCast(Type wantedType) {
        InsnList list = new InsnList();
        if (wantedType.equals((Object)Type.BOOLEAN_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.IN_Boolean));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.IN_Boolean, "booleanValue", Types.methodDescriptor(Boolean.TYPE, new Object[0]), false));
        } else if (wantedType.equals((Object)Type.BYTE_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.IN_Byte));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.IN_Byte, "byteValue", Types.methodDescriptor(Byte.TYPE, new Object[0]), false));
        } else if (wantedType.equals((Object)Type.CHAR_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.IN_Character));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.IN_Character, "charValue", Types.methodDescriptor(Character.TYPE, new Object[0]), false));
        } else if (wantedType.equals((Object)Type.SHORT_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.IN_Short));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.IN_Short, "shortValue", Types.methodDescriptor(Short.TYPE, new Object[0]), false));
        } else if (wantedType.equals((Object)Type.INT_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.IN_Integer));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.IN_Integer, "intValue", Types.methodDescriptor(Integer.TYPE, new Object[0]), false));
        } else if (wantedType.equals((Object)Type.FLOAT_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.IN_Float));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.IN_Float, "floatValue", Types.methodDescriptor(Float.TYPE, new Object[0]), false));
        } else if (wantedType.equals((Object)Type.LONG_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.IN_Long));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.IN_Long, "longValue", Types.methodDescriptor(Long.TYPE, new Object[0]), false));
        } else if (wantedType.equals((Object)Type.DOUBLE_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.IN_Double));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.IN_Double, "doubleValue", Types.methodDescriptor(Double.TYPE, new Object[0]), false));
        } else {
            list.add((AbstractInsnNode)new TypeInsnNode(192, wantedType.getInternalName()));
        }
        return list;
    }

    @Nullable
    public static AbstractInsnNode getPrimitiveToObject(Type primitive) {
        if (primitive.equals((Object)Type.BOOLEAN_TYPE)) {
            return new MethodInsnNode(184, Types.IN_Boolean, "valueOf", Types.methodDescriptor(Boolean.class, Boolean.TYPE), false);
        }
        if (primitive.equals((Object)Type.BYTE_TYPE)) {
            return new MethodInsnNode(184, Types.IN_Byte, "valueOf", Types.methodDescriptor(Byte.class, Byte.TYPE), false);
        }
        if (primitive.equals((Object)Type.SHORT_TYPE)) {
            return new MethodInsnNode(184, Types.IN_Short, "valueOf", Types.methodDescriptor(Short.class, Short.TYPE), false);
        }
        if (primitive.equals((Object)Type.CHAR_TYPE)) {
            return new MethodInsnNode(184, Types.IN_Character, "valueOf", Types.methodDescriptor(Character.class, Character.TYPE), false);
        }
        if (primitive.equals((Object)Type.INT_TYPE)) {
            return new MethodInsnNode(184, Types.IN_Integer, "valueOf", Types.methodDescriptor(Integer.class, Integer.TYPE), false);
        }
        if (primitive.equals((Object)Type.LONG_TYPE)) {
            return new MethodInsnNode(184, Types.IN_Long, "valueOf", Types.methodDescriptor(Long.class, Long.TYPE), false);
        }
        if (primitive.equals((Object)Type.FLOAT_TYPE)) {
            return new MethodInsnNode(184, Types.IN_Float, "valueOf", Types.methodDescriptor(Float.class, Float.TYPE), false);
        }
        if (primitive.equals((Object)Type.DOUBLE_TYPE)) {
            return new MethodInsnNode(184, Types.IN_Double, "valueOf", Types.methodDescriptor(Double.class, Double.TYPE), false);
        }
        return null;
    }

    @Nullable
    public static MemberDeclaration splitMemberDeclaration(String memberDeclaration) {
        Matcher matcher;
        if (memberDeclaration.matches(METHOD_DECLARATION_PATTERN)) {
            Matcher matcher2 = Pattern.compile(METHOD_DECLARATION_PATTERN).matcher(memberDeclaration);
            if (matcher2.find()) {
                return new MemberDeclaration(matcher2.group(1) == null ? matcher2.group(2) : matcher2.group(1), matcher2.group(3), matcher2.group(4));
            }
        } else if (memberDeclaration.matches(FIELD_DECLARATION_PATTERN) && (matcher = Pattern.compile(FIELD_DECLARATION_PATTERN).matcher(memberDeclaration)).find()) {
            return new MemberDeclaration(matcher.group(1) == null ? matcher.group(2) : matcher.group(1), matcher.group(3), matcher.group(4));
        }
        return null;
    }

    @Nullable
    public static AbstractInsnNode getFirstConstructorInstruction(String superClass, MethodNode methodNode) {
        for (AbstractInsnNode first = methodNode.instructions.getFirst(); first != null; first = first.getNext()) {
            if (first.getOpcode() != 183 || !((MethodInsnNode)first).owner.equals(superClass)) continue;
            return first.getNext();
        }
        return null;
    }

    @Nullable
    public static Number getNumber(@Nullable AbstractInsnNode instruction) {
        if (instruction == null) {
            return null;
        }
        if (instruction.getOpcode() >= 2 && instruction.getOpcode() <= 8) {
            return instruction.getOpcode() - 3;
        }
        if (instruction.getOpcode() >= 9 && instruction.getOpcode() <= 10) {
            return (long)(instruction.getOpcode() - 9);
        }
        if (instruction.getOpcode() >= 11 && instruction.getOpcode() <= 13) {
            return Float.valueOf(instruction.getOpcode() - 11);
        }
        if (instruction.getOpcode() >= 14 && instruction.getOpcode() <= 15) {
            return (double)(instruction.getOpcode() - 14);
        }
        if (instruction.getOpcode() == 16) {
            return (byte)((IntInsnNode)instruction).operand;
        }
        if (instruction.getOpcode() == 17) {
            return (short)((IntInsnNode)instruction).operand;
        }
        if (instruction.getOpcode() == 18 && ((LdcInsnNode)instruction).cst instanceof Number) {
            return (Number)((LdcInsnNode)instruction).cst;
        }
        return null;
    }

    public static boolean compareTypes(Type[] types, Type[] targetTypes) {
        return ASMUtils.compareTypes(types, targetTypes, false, new Type[0]);
    }

    public static boolean compareTypes(Type[] types, Type[] targetTypes, boolean prepend, Type ... additionalNeededTypes) {
        if (additionalNeededTypes.length > 0) {
            Type[] mergedTypes = new Type[types.length + additionalNeededTypes.length];
            if (prepend) {
                System.arraycopy(additionalNeededTypes, 0, mergedTypes, 0, additionalNeededTypes.length);
                System.arraycopy(types, 0, mergedTypes, additionalNeededTypes.length, types.length);
            } else {
                System.arraycopy(types, 0, mergedTypes, 0, types.length);
                System.arraycopy(additionalNeededTypes, 0, mergedTypes, types.length, additionalNeededTypes.length);
            }
            types = mergedTypes;
        }
        if (types.length != targetTypes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            Type targetType = targetTypes[i];
            boolean areEqual = type.equals((Object)targetType);
            if (type.getSort() != 10 && !areEqual) {
                return false;
            }
            if (areEqual || targetType.equals((Object)Type.getType(Object.class))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareType(Type type, Type targetType) {
        if (type.equals((Object)targetType)) {
            return true;
        }
        return type.getSort() == 10 && targetType.equals((Object)Type.getType(Object.class));
    }

    public static ClassNode cloneClass(ClassNode classNode) {
        ClassNode clonedClass = new ClassNode();
        classNode.accept((ClassVisitor)clonedClass);
        return clonedClass;
    }

    public static MethodNode cloneMethod(MethodNode methodNode) {
        MethodNode clonedMethod = new MethodNode(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions == null ? null : methodNode.exceptions.toArray(new String[0]));
        methodNode.accept((MethodVisitor)clonedMethod);
        return clonedMethod;
    }

    public static InsnList cloneInsnList(InsnList insnList) {
        InsnList clonedInsnList = new InsnList();
        Map<LabelNode, LabelNode> clonedLabels = ASMUtils.cloneLabels(insnList);
        for (AbstractInsnNode instruction : insnList.toArray()) {
            clonedInsnList.add(instruction.clone(clonedLabels));
        }
        return clonedInsnList;
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList original) {
        HashMap<LabelNode, LabelNode> clonedLabels = new HashMap<LabelNode, LabelNode>();
        for (AbstractInsnNode instruction : original) {
            if (!(instruction instanceof LabelNode)) continue;
            clonedLabels.put((LabelNode)instruction, new LabelNode());
        }
        return clonedLabels;
    }

    public static ClassNode createEmptyClass(String name) {
        ClassNode node = new ClassNode();
        node.visit(52, 1, ASMUtils.slash(name), null, Types.IN_Object, null);
        MethodNode constructor = new MethodNode(1, "<init>", Types.MD_Void, null, null);
        constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        constructor.instructions.add((AbstractInsnNode)new MethodInsnNode(183, Types.IN_Object, "<init>", Types.MD_Void));
        constructor.instructions.add((AbstractInsnNode)new InsnNode(177));
        node.methods.add(constructor);
        return node;
    }

    public static AbstractInsnNode intPush(int i) {
        if (i >= -1 && i <= 5) {
            return new InsnNode(3 + i);
        }
        if (i >= -128 && i <= 127) {
            return new IntInsnNode(16, i);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return new IntInsnNode(17, i);
        }
        return new LdcInsnNode((Object)i);
    }

    public static int[] getParameterIndices(MethodNode methodNode) {
        return ASMUtils.getParameterIndices(Types.argumentTypes(methodNode), Modifier.isStatic(methodNode.access));
    }

    public static int[] getParameterIndices(Type[] types, boolean isStatic) {
        int[] indices = new int[types.length];
        int current = isStatic ? 0 : 1;
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            indices[i] = current;
            current += type.getSize();
        }
        return indices;
    }

    public static void cutParameters(MethodNode methodNode, int count) {
        if (count == 0) {
            return;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        Type[] parameters = Types.argumentTypes(methodNode);
        parameters = Arrays.copyOf(parameters, parameters.length - count);
        methodNode.desc = Types.methodDescriptor(Types.returnType(methodNode), parameters);
        if (methodNode.visibleParameterAnnotations != null) {
            methodNode.visibleParameterAnnotations = Arrays.copyOf(methodNode.visibleParameterAnnotations, methodNode.visibleParameterAnnotations.length - count);
        }
        if (methodNode.invisibleParameterAnnotations != null) {
            methodNode.invisibleParameterAnnotations = Arrays.copyOf(methodNode.invisibleParameterAnnotations, methodNode.invisibleParameterAnnotations.length - count);
        }
        if (methodNode.visibleAnnotableParameterCount > 0 && methodNode.visibleAnnotableParameterCount > parameters.length) {
            methodNode.visibleAnnotableParameterCount = parameters.length;
        }
        if (methodNode.invisibleAnnotableParameterCount > 0 && methodNode.invisibleAnnotableParameterCount > parameters.length) {
            methodNode.invisibleAnnotableParameterCount = parameters.length;
        }
    }

    public static void removeParameters(MethodNode methodNode, int ... indices) {
        if (indices.length == 0) {
            return;
        }
        Arrays.sort(indices);
        ArrayList<Type> parameterList = new ArrayList<Type>(Arrays.asList(Types.argumentTypes(methodNode)));
        Optional<List> visibleParameterAnnotations = Optional.ofNullable(methodNode.visibleParameterAnnotations).map(Arrays::asList).map(ArrayList::new);
        Optional<List> invisibleParameterAnnotations = Optional.ofNullable(methodNode.invisibleParameterAnnotations).map(Arrays::asList).map(ArrayList::new);
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            parameterList.remove(index);
            visibleParameterAnnotations.ifPresent(annotations -> {
                List cfr_ignored_0 = (List)annotations.remove(index);
            });
            invisibleParameterAnnotations.ifPresent(annotations -> {
                List cfr_ignored_0 = (List)annotations.remove(index);
            });
            if (methodNode.visibleAnnotableParameterCount > 0 && index < methodNode.visibleAnnotableParameterCount) {
                --methodNode.visibleAnnotableParameterCount;
            }
            if (methodNode.invisibleAnnotableParameterCount <= 0 || index >= methodNode.invisibleAnnotableParameterCount) continue;
            --methodNode.invisibleAnnotableParameterCount;
        }
        methodNode.desc = Types.methodDescriptor(Types.returnType(methodNode), parameterList.toArray(new Type[0]));
        methodNode.visibleParameterAnnotations = visibleParameterAnnotations.map(l -> l.toArray(new List[0])).orElse(null);
        methodNode.invisibleParameterAnnotations = invisibleParameterAnnotations.map(l -> l.toArray(new List[0])).orElse(null);
    }

    public static void addParameters(MethodNode methodNode, Type ... parameters) {
        if (parameters.length == 0) {
            return;
        }
        Type[] oldParameters = Types.argumentTypes(methodNode);
        Type[] newParameters = new Type[oldParameters.length + parameters.length];
        System.arraycopy(oldParameters, 0, newParameters, 0, oldParameters.length);
        System.arraycopy(parameters, 0, newParameters, oldParameters.length, parameters.length);
        methodNode.desc = Types.methodDescriptor(Types.returnType(methodNode), newParameters);
        if (methodNode.visibleParameterAnnotations != null) {
            methodNode.visibleParameterAnnotations = Arrays.copyOf(methodNode.visibleParameterAnnotations, methodNode.visibleParameterAnnotations.length + 1);
        }
        if (methodNode.invisibleParameterAnnotations != null) {
            methodNode.invisibleParameterAnnotations = Arrays.copyOf(methodNode.invisibleParameterAnnotations, methodNode.invisibleParameterAnnotations.length + 1);
        }
    }

    public static InsnList swap(Type top, Type bottom) {
        InsnList insns = new InsnList();
        if (top.getSize() == 1 && bottom.getSize() == 1) {
            insns.add((AbstractInsnNode)new InsnNode(95));
        } else if (top.getSize() == 2 && bottom.getSize() == 2) {
            insns.add((AbstractInsnNode)new InsnNode(94));
            insns.add((AbstractInsnNode)new InsnNode(88));
        } else if (top.getSize() == 2) {
            insns.add((AbstractInsnNode)new InsnNode(91));
            insns.add((AbstractInsnNode)new InsnNode(87));
        } else {
            insns.add((AbstractInsnNode)new InsnNode(93));
            insns.add((AbstractInsnNode)new InsnNode(88));
        }
        return insns;
    }

    public static String dot(String s) {
        return s.replace('/', '.');
    }

    public static String slash(String s) {
        return s.replace('.', '/');
    }
}

