/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;

public class HelpAppender {
    private static final Field COMMAND_FIELD;

    public static <S> CommandDispatcher<S> newAutoHelpAppendingCommandDispatcher(final HelpSender<S> helpSender) {
        return new CommandDispatcher<S>(){

            public LiteralCommandNode<S> register(LiteralArgumentBuilder<S> command) {
                LiteralCommandNode node = super.register(command);
                HelpAppender.appendHelpExecutor(helpSender, this, node);
                return node;
            }
        };
    }

    public static <S> void appendHelpExecutor(HelpSender<S> helpSender, CommandDispatcher<S> dispatcher, CommandNode<S> commandNode) {
        Set visited = Collections.newSetFromMap(new WeakHashMap());
        Stack<CommandNode<S>> toVisit = new Stack<CommandNode<S>>();
        toVisit.push(commandNode);
        while (!toVisit.isEmpty()) {
            CommandNode node = (CommandNode)toVisit.pop();
            if (visited.contains(node)) continue;
            visited.add(node);
            if (node.getCommand() == null) {
                Command command = ctx -> {
                    if (node.getRedirect() != null) {
                        HelpAppender.printHelp(helpSender, dispatcher, node.getRedirect(), ctx.getSource(), node.getName(), ctx.getInput());
                    } else {
                        HelpAppender.printHelp(helpSender, dispatcher, node, ctx.getSource(), node.getName(), ctx.getInput());
                    }
                    return 1;
                };
                try {
                    COMMAND_FIELD.set(node, command);
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unable to set command field in CommandNode", t);
                }
            }
            node.getChildren().forEach(toVisit::push);
        }
    }

    public static <S> void printHelp(HelpSender<S> helpSender, CommandDispatcher<S> dispatcher, CommandNode<S> commandNode, S sender, String name, String prefix) {
        ArrayList<String> usages = new ArrayList<String>();
        Map smartUsage = dispatcher.getSmartUsage(commandNode, sender);
        for (Map.Entry entry : smartUsage.entrySet()) {
            CommandNode node = (CommandNode)entry.getKey();
            String usage = (String)entry.getValue();
            if (!node.canUse(sender)) continue;
            if (node.getRedirect() != null) {
                ArrayList<String> subChildren = new ArrayList<String>();
                for (CommandNode subChild : node.getRedirect().getChildren()) {
                    if (!subChild.canUse(sender)) continue;
                    subChildren.add(subChild.getName());
                }
                usage = node.getName() + " (" + String.join((CharSequence)"|", subChildren) + ") ";
            }
            usages.add((prefix.isEmpty() ? "" : prefix + " ") + usage);
        }
        helpSender.send(sender, name, usages);
    }

    static {
        try {
            COMMAND_FIELD = CommandNode.class.getDeclaredField("command");
            COMMAND_FIELD.setAccessible(true);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to find 'command' field in CommandNode class", t);
        }
    }

    @FunctionalInterface
    public static interface HelpSender<S> {
        public void send(S var1, String var2, List<String> var3);
    }
}

