/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class LineArgumentBuilder<S>
extends ArgumentBuilder<S, LineArgumentBuilder<S>> {
    private static final Field ARGUMENTS_FIELD = ((Supplier<Field>)() -> {
        try {
            Field f = CommandContext.class.getDeclaredField("arguments");
            f.setAccessible(true);
            return f;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not find the arguments field in CommandContext", t);
        }
    }).get();
    private final ArgumentBuilder<S, ?> parent;
    private final List<LineNode<S>> nodes = new ArrayList<LineNode<S>>();
    private Command<S> executor;

    public static <S> LineArgumentBuilder<S> create() {
        return new LineArgumentBuilder<S>();
    }

    public static <S> LineArgumentBuilder<S> create(ArgumentBuilder<S, ?> parent) {
        return new LineArgumentBuilder<S>(parent);
    }

    private LineArgumentBuilder() {
        this(null);
    }

    private LineArgumentBuilder(@Nullable ArgumentBuilder<S, ?> parent) {
        this.parent = parent;
    }

    public LineArgumentBuilder<S> node(ArgumentBuilder<S, ?> node) {
        this.checkMutable();
        this.nodes.add(new LineNode(null, node));
        return this;
    }

    public LineArgumentBuilder<S> literal(String name) {
        return this.node((ArgumentBuilder<S, ?>)LiteralArgumentBuilder.literal((String)name));
    }

    public LineArgumentBuilder<S> argument(String name, ArgumentType<?> type) {
        this.checkMutable();
        this.nodes.add(new LineNode(name, (ArgumentBuilder)RequiredArgumentBuilder.argument((String)name, type)));
        return this;
    }

    public LineArgumentBuilder<S> require(Predicate<S> requirement) {
        this.checkMutable();
        this.requires(ArgumentBuilder.class).requires(requirement);
        return this;
    }

    public LineArgumentBuilder<S> suggest(SuggestionProvider<S> provider) {
        this.checkMutable();
        this.requires(RequiredArgumentBuilder.class).suggests(provider);
        return this;
    }

    public LineArgumentBuilder<S> defaultValue() {
        this.checkMutable();
        this.requires(LiteralArgumentBuilder.class);
        if (this.nodes.size() == 1 && this.parent == null) {
            throw new IllegalStateException("A parent node must be set to use a default value on the first node");
        }
        ((LineNode)this.getLastNode()).defaultValue = () -> "";
        return this;
    }

    public LineArgumentBuilder<S> defaultValue(Object defaultValue) {
        return this.defaultValue(() -> defaultValue);
    }

    public LineArgumentBuilder<S> defaultValue(Supplier<Object> supplier) {
        this.checkMutable();
        this.requires(RequiredArgumentBuilder.class);
        if (this.nodes.size() == 1 && this.parent == null) {
            throw new IllegalStateException("A parent node must be set to use a default value on the first node");
        }
        ((LineNode)this.getLastNode()).defaultValue = supplier;
        return this;
    }

    public ArgumentBuilder<S, ?> execute(Consumer<CommandContext<S>> executor) {
        return this.execute(context -> {
            executor.accept(context);
            return 1;
        });
    }

    public ArgumentBuilder<S, ?> execute(Command<S> executor) {
        this.checkMutable();
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("Cannot add an executor to a builder with no nodes");
        }
        this.executor = executor;
        return this;
    }

    protected LineArgumentBuilder<S> getThis() {
        return this;
    }

    public CommandNode<S> build() {
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("Cannot build a builder with no nodes");
        }
        CommandNode root = null;
        CommandNode current = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            LineNode<S> next;
            LineNode<S> node = this.nodes.get(i);
            LineNode<S> lineNode = next = i + 1 < this.nodes.size() ? this.nodes.get(i + 1) : null;
            if (i == 0 && ((LineNode)node).defaultValue != null) {
                this.parent.executes(this.makeDefaultExecutor(0));
            }
            if (next == null || ((LineNode)next).defaultValue != null) {
                ((LineNode)node).node.executes(this.makeDefaultExecutor(i + 1));
            }
            CommandNode newNode = ((LineNode)node).node.build();
            if (root == null) {
                root = newNode;
            }
            if (current != null) {
                current.addChild(newNode);
            }
            current = newNode;
        }
        return root;
    }

    private Command<S> makeDefaultExecutor(int start) {
        return ctx -> {
            Map arguments;
            try {
                arguments = (Map)ARGUMENTS_FIELD.get(ctx);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not get arguments from CommandContext", e);
            }
            List<LineNode<S>> missing = this.nodes.subList(start, this.nodes.size());
            for (LineNode<S> missingNode : missing) {
                if (((LineNode)missingNode).name == null || ((LineNode)missingNode).defaultValue == null) continue;
                arguments.put(((LineNode)missingNode).name, new ParsedArgument(-1, -1, ((LineNode)missingNode).defaultValue.get()));
            }
            return this.executor.run(ctx);
        };
    }

    private void checkMutable() {
        if (this.executor != null) {
            throw new IllegalStateException("Cannot modify a builder that already has an executor");
        }
    }

    private LineNode<S> getLastNode() {
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("No nodes added yet");
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    private <T> T requires(Class<T> type) {
        LineNode<S> node = this.getLastNode();
        if (!type.isAssignableFrom(((LineNode)node).node.getClass())) {
            throw new IllegalStateException("Last node is not of type " + type.getSimpleName());
        }
        return type.cast(((LineNode)node).node);
    }

    private static class LineNode<S> {
        @Nullable
        private final String name;
        private final ArgumentBuilder<S, ?> node;
        @Nullable
        private Supplier<Object> defaultValue;

        private LineNode(@Nullable String name, ArgumentBuilder<S, ?> node) {
            this.name = name;
            this.node = node;
        }
    }
}

