/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.swing.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    private final int padding;
    private final int gap;

    public VerticalLayout() {
        this(0, 0);
    }

    public VerticalLayout(int padding, int gap) {
        this.padding = padding;
        this.gap = gap;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getGap() {
        return this.gap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        for (Component component : parent.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension preferredSize = component.getPreferredSize();
            width = Math.max(width, preferredSize.width);
            height += this.gap + preferredSize.height;
        }
        if (height > 0) {
            height -= this.gap;
        }
        Insets insets = parent.getInsets();
        return new Dimension((width += insets.left + insets.right) + this.padding * 2, (height += insets.top + insets.bottom) + this.padding * 2);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int width = parent.getWidth() - insets.left - insets.right - this.padding * 2;
        int height = insets.top + this.padding;
        for (Component component : parent.getComponents()) {
            if (!component.isVisible()) continue;
            component.setBounds(insets.left + this.padding, height, width, component.getPreferredSize().height);
            height += component.getSize().height + this.gap;
        }
    }
}

