/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Box;

public class GBC {
    public static final int RELATIVE = -1;
    public static final int REMAINDER = 0;
    public static final int HORIZONTAL = 2;
    public static final int NONE = 0;
    public static final int BOTH = 1;
    public static final int VERTICAL = 3;
    public static final int CENTER = 10;
    public static final int NORTH = 11;
    public static final int NORTHEAST = 12;
    public static final int EAST = 13;
    public static final int SOUTHEAST = 14;
    public static final int SOUTH = 15;
    public static final int SOUTHWEST = 16;
    public static final int WEST = 17;
    public static final int NORTHWEST = 18;
    public static final int PAGE_START = 19;
    public static final int PAGE_END = 20;
    public static final int LINE_START = 21;
    public static final int LINE_END = 22;
    public static final int FIRST_LINE_START = 23;
    public static final int FIRST_LINE_END = 24;
    public static final int LAST_LINE_START = 25;
    public static final int LAST_LINE_END = 26;
    public static final int BASELINE = 256;
    public static final int BASELINE_LEADING = 512;
    public static final int BASELINE_TRAILING = 768;
    public static final int ABOVE_BASELINE = 1024;
    public static final int ABOVE_BASELINE_LEADING = 1280;
    public static final int ABOVE_BASELINE_TRAILING = 1536;
    public static final int BELOW_BASELINE = 1792;
    public static final int BELOW_BASELINE_LEADING = 2048;
    public static final int BELOW_BASELINE_TRAILING = 2304;
    private final Container parent;
    private final GridBagConstraints constraints;

    public static GBC create() {
        return GBC.create(null);
    }

    public static GBC create(Container parent) {
        return new GBC(parent);
    }

    public static OptionalInt currentGridX(Container container) {
        GridBagLayout layout = (GridBagLayout)container.getLayout();
        Integer gridx = null;
        Integer gridy = null;
        for (Component component : container.getComponents()) {
            GridBagConstraints gbc = layout.getConstraints(component);
            if (gridy == null || gbc.gridy > gridy) {
                gridx = gbc.gridx;
                gridy = gbc.gridy;
                continue;
            }
            if (gbc.gridy != gridy || gbc.gridx <= gridx) continue;
            gridx = gbc.gridx;
        }
        if (gridx == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(gridx);
    }

    public static OptionalInt currentGridY(Container container) {
        GridBagLayout layout = (GridBagLayout)container.getLayout();
        Integer gridy = null;
        for (Component component : container.getComponents()) {
            GridBagConstraints gbc = layout.getConstraints(component);
            if (gridy != null && gbc.gridy <= gridy) continue;
            gridy = gbc.gridy;
        }
        if (gridy == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(gridy);
    }

    public static int fillVerticalSpace(Container parent) {
        int gridy = GBC.currentGridY(parent).orElse(-1);
        GBC.fillVerticalSpace(parent, ++gridy);
        return gridy + 1;
    }

    public static void fillVerticalSpace(Container parent, int gridy) {
        GBC.create(parent).gridy(gridy).anchor(17).weighty(1.0).fill(2).add(Box.createVerticalGlue());
    }

    private GBC(Container parent) {
        this.parent = parent;
        this.constraints = new GridBagConstraints();
    }

    public GBC nextColumn() {
        this.constraints.gridx = GBC.currentGridX(this.parent).orElse(-1) + 1;
        this.constraints.gridy = GBC.currentGridY(this.parent).orElse(0);
        return this;
    }

    public GBC nextRow() {
        this.constraints.gridx = 0;
        this.constraints.gridy = GBC.currentGridY(this.parent).orElse(-1) + 1;
        return this;
    }

    public GBC skipColumn() {
        ++this.constraints.gridx;
        return this;
    }

    public GBC skipRow() {
        this.constraints.gridx = 0;
        ++this.constraints.gridy;
        return this;
    }

    public GBC gridx(int gridx) {
        this.constraints.gridx = gridx;
        return this;
    }

    public GBC gridy(int gridy) {
        this.constraints.gridy = gridy;
        return this;
    }

    public GBC grid(int gridx, int gridy) {
        this.constraints.gridx = gridx;
        this.constraints.gridy = gridy;
        return this;
    }

    public GBC width(int gridwidth) {
        this.constraints.gridwidth = gridwidth;
        return this;
    }

    public GBC height(int gridheight) {
        this.constraints.gridheight = gridheight;
        return this;
    }

    public GBC size(int gridwidth, int gridheight) {
        this.constraints.gridwidth = gridwidth;
        this.constraints.gridheight = gridheight;
        return this;
    }

    public GBC weightx(double weightx) {
        this.constraints.weightx = weightx;
        return this;
    }

    public GBC weighty(double weighty) {
        this.constraints.weighty = weighty;
        return this;
    }

    public GBC weight(double weightx, double weighty) {
        this.constraints.weightx = weightx;
        this.constraints.weighty = weighty;
        return this;
    }

    public GBC anchor(int anchor) {
        this.constraints.anchor = anchor;
        return this;
    }

    public GBC fill(int fill) {
        this.constraints.fill = fill;
        return this;
    }

    public GBC fillx(int fill, double weightx) {
        this.constraints.fill = fill;
        this.constraints.weightx = weightx;
        return this;
    }

    public GBC filly(int fill, double weighty) {
        this.constraints.fill = fill;
        this.constraints.weighty = weighty;
        return this;
    }

    public GBC fillxy(int fill, double weightx, double weighty) {
        this.constraints.fill = fill;
        this.constraints.weightx = weightx;
        this.constraints.weighty = weighty;
        return this;
    }

    public GBC insets(Insets insets) {
        this.constraints.insets = insets;
        return this;
    }

    public GBC insets(int all) {
        this.constraints.insets = new Insets(all, all, all, all);
        return this;
    }

    public GBC insets(int topBottom, int leftRight) {
        this.constraints.insets = new Insets(topBottom, leftRight, topBottom, leftRight);
        return this;
    }

    public GBC insets(int top, int left, int bottom, int right) {
        this.constraints.insets = new Insets(top, left, bottom, right);
        return this;
    }

    public GBC ipadx(int ipadx) {
        this.constraints.ipadx = ipadx;
        return this;
    }

    public GBC ipady(int ipady) {
        this.constraints.ipady = ipady;
        return this;
    }

    public GBC ipad(int ipadx, int ipady) {
        this.constraints.ipadx = ipadx;
        this.constraints.ipady = ipady;
        return this;
    }

    public GBC add(Component component) {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot add component without parent");
        }
        this.parent.add(component, this.constraints);
        return this;
    }

    public GBC add(Component component, Runnable runnable) {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot add component without parent");
        }
        runnable.run();
        this.parent.add(component, this.constraints);
        return this;
    }

    public <C extends Component> GBC add(C component, Consumer<C> consumer) {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot add component without parent");
        }
        consumer.accept(component);
        this.parent.add(component, this.constraints);
        return this;
    }

    public GBC add(Supplier<Component> supplier) {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot add component without parent");
        }
        this.parent.add(supplier.get(), this.constraints);
        return this;
    }

    public GridBagConstraints get() {
        return this.constraints;
    }
}

