/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.converter.impl.v1_21_5;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.converter.impl.v1_20_3.NbtConverter_v1_20_3;
import net.lenni0451.mcstructs.converter.model.Result;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.snbt.SNbt;

public class NbtConverter_v1_21_5
extends NbtConverter_v1_20_3 {
    public static final NbtConverter_v1_21_5 INSTANCE = new NbtConverter_v1_21_5();

    public NbtConverter_v1_21_5() {
        this((SNbt<CompoundTag>)SNbt.V1_21_5);
    }

    protected NbtConverter_v1_21_5(SNbt<CompoundTag> sNbt) {
        super(sNbt);
    }

    @Override
    public Result<NbtTag> mergeList(@Nullable NbtTag list, List<NbtTag> values) {
        Result<List<NbtTag>> listResult;
        ListType listType;
        if (list == null) {
            listType = ListType.LIST;
        } else if (list instanceof ByteArrayTag) {
            listType = list.asByteArrayTag().isEmpty() ? ListType.LIST : ListType.BYTE;
        } else if (list instanceof IntArrayTag) {
            listType = list.asIntArrayTag().isEmpty() ? ListType.LIST : ListType.INT;
        } else if (list instanceof LongArrayTag) {
            listType = list.asLongArrayTag().isEmpty() ? ListType.LIST : ListType.LONG;
        } else if (list instanceof ListTag) {
            ListTag listTag = list.asListTag();
            listType = NbtType.COMPOUND.equals((Object)listTag.getType()) ? ListType.MIXED_LIST : ListType.LIST;
        } else {
            return Result.error("Invalid list tag: " + list);
        }
        Result<List<Object>> result = listResult = list == null ? Result.success(new ArrayList()) : this.asList(list);
        if (listResult.isError()) {
            return listResult.mapError();
        }
        List<NbtTag> tags = listResult.get();
        tags.addAll(values);
        if (tags.isEmpty()) {
            return Result.success(new ListTag());
        }
        if (listType.equals((Object)ListType.BYTE)) {
            if (tags.stream().allMatch(NbtTag::isByteTag)) {
                byte[] bytes = new byte[tags.size()];
                for (int i = 0; i < tags.size(); ++i) {
                    bytes[i] = tags.get(i).asByteTag().getValue();
                }
                return Result.success(new ByteArrayTag(bytes));
            }
        } else if (listType.equals((Object)ListType.INT)) {
            if (tags.stream().allMatch(NbtTag::isIntTag)) {
                int[] ints = new int[tags.size()];
                for (int i = 0; i < tags.size(); ++i) {
                    ints[i] = tags.get(i).asIntTag().getValue();
                }
                return Result.success(new IntArrayTag(ints));
            }
        } else if (listType.equals((Object)ListType.LONG)) {
            if (tags.stream().allMatch(NbtTag::isLongTag)) {
                long[] longs = new long[tags.size()];
                for (int i = 0; i < tags.size(); ++i) {
                    longs[i] = tags.get(i).asLongTag().getValue();
                }
                return Result.success(new LongArrayTag(longs));
            }
        } else if (listType.equals((Object)ListType.LIST)) {
            NbtType type = null;
            for (NbtTag tag : tags) {
                if (type == null) {
                    type = tag.getNbtType();
                    continue;
                }
                if (type.equals((Object)tag.getNbtType())) continue;
                type = null;
                break;
            }
            if (type != null) {
                return Result.success(new ListTag(tags));
            }
        }
        ListTag out = new ListTag();
        for (NbtTag tag : tags) {
            boolean isMarker;
            boolean bl = isMarker = tag.isCompoundTag() && tag.asCompoundTag().size() == 1 && tag.asCompoundTag().contains("");
            if (tag.isCompoundTag() && !isMarker) {
                out.add(tag);
                continue;
            }
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.add("", tag);
            out.add((NbtTag)compoundTag);
        }
        return Result.success(out);
    }

    private static enum ListType {
        BYTE,
        INT,
        LONG,
        LIST,
        MIXED_LIST;

    }
}

