/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io;

import net.lenni0451.mcstructs.nbt.exceptions.NbtReadException;

public class NbtReadTracker {
    public static final long DEFAULT_MAX_BYTES = 0x200000L;
    public static final int DEFAULT_MAX_DEPTH = 512;
    private final int maxDepth;
    private final long maxBytes;
    private int depth;
    private long size;

    public static NbtReadTracker unlimitedDepth() {
        return new NbtReadTracker(0L){

            @Override
            public void read(long bytes) {
            }
        };
    }

    public NbtReadTracker() {
        this(0x200000L);
    }

    public NbtReadTracker(long maxBytes) {
        this(512, maxBytes);
    }

    public NbtReadTracker(int maxDepth, long maxBytes) {
        this.maxDepth = maxDepth;
        this.maxBytes = maxBytes;
    }

    public void pushDepth() throws NbtReadException {
        ++this.depth;
        if (this.depth > 512) {
            throw new NbtReadException("Tried to read Nbt with more depth than allowed (" + this.maxDepth + ")");
        }
    }

    public void popDepth() {
        --this.depth;
    }

    public void read(long bytes) throws NbtReadException {
        this.size = Math.addExact(this.size, bytes);
        if (this.size > this.maxBytes) {
            throw new NbtReadException("Tried to read larger Nbt than allowed. Needed bytes " + this.size + " but max is " + this.maxBytes + " bytes");
        }
    }

    public void read(long bytes, long multiplier) throws NbtReadException {
        this.read(Math.multiplyExact(bytes, multiplier));
    }
}

