/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.internal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.io.NamedTag;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.NbtReadTracker;
import net.lenni0451.mcstructs.nbt.io.impl.NbtReader;

@ParametersAreNonnullByDefault
public interface NbtReadWrapper {
    public NbtReader getReader();

    @Nullable
    default public NbtTag readFile(File f, NbtReadTracker readTracker) throws IOException {
        return this.readFile(f, false, readTracker);
    }

    @Nullable
    default public NbtTag readCompressedFile(File f, NbtReadTracker readTracker) throws IOException {
        return this.readFile(f, true, readTracker);
    }

    @Nullable
    default public NbtTag readFile(File f, boolean compressed, NbtReadTracker readTracker) throws IOException {
        try (InputStream fis = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            NbtTag nbtTag = this.read(fis, compressed, readTracker);
            return nbtTag;
        }
    }

    @Nullable
    @WillNotClose
    default public NbtTag read(InputStream is, boolean compressed, NbtReadTracker readTracker) throws IOException {
        if (compressed) {
            return this.read(new DataInputStream(new GZIPInputStream(is)), readTracker);
        }
        return this.read(new DataInputStream(is), readTracker);
    }

    @Nullable
    @WillNotClose
    default public NbtTag read(DataInput in, NbtReadTracker readTracker) throws IOException {
        NamedTag named = this.readNamed(in, readTracker);
        if (named == null) {
            return null;
        }
        return named.getTag();
    }

    @Nullable
    default public NamedTag readNamed(DataInput in, NbtReadTracker readTracker) throws IOException {
        NbtHeader header = this.getReader().readHeader(in, readTracker);
        if (header.isEnd()) {
            return null;
        }
        readTracker.pushDepth();
        NbtTag tag = this.getReader().read(header.getType(), in, readTracker);
        readTracker.popDepth();
        return new NamedTag(header.getName(), header.getType(), tag);
    }

    @Nullable
    default public NbtTag readUnnamed(DataInput in, NbtReadTracker readTracker) throws IOException {
        NbtType type = this.getReader().readType(in, readTracker);
        if (NbtType.END.equals((Object)type)) {
            return null;
        }
        readTracker.pushDepth();
        NbtTag tag = this.getReader().read(type, in, readTracker);
        readTracker.popDepth();
        return tag;
    }
}

