/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.Objects;
import net.lenni0451.mcstructs.nbt.NbtNumber;
import net.lenni0451.mcstructs.nbt.NbtType;

public class DoubleTag
implements NbtNumber {
    private double value;

    public DoubleTag() {
        this(0.0);
    }

    public DoubleTag(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public DoubleTag setValue(double value) {
        this.value = value;
        return this;
    }

    @Override
    public byte byteValue() {
        return (byte)((int)Math.floor(this.value) & 0xFF);
    }

    @Override
    public short shortValue() {
        return (short)((int)Math.floor(this.value) & 0xFFFF);
    }

    @Override
    public int intValue() {
        return (int)Math.floor(this.value);
    }

    @Override
    public long longValue() {
        return (long)Math.floor(this.value);
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.DOUBLE;
    }

    @Override
    public DoubleTag copy() {
        return new DoubleTag(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleTag doubleTag = (DoubleTag)o;
        return Double.compare(doubleTag.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public String toString() {
        return "double(" + this.value + ")";
    }
}

