/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.Objects;
import net.lenni0451.mcstructs.nbt.NbtNumber;
import net.lenni0451.mcstructs.nbt.NbtType;

public class FloatTag
implements NbtNumber {
    private float value;

    public FloatTag() {
        this(0.0f);
    }

    public FloatTag(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    public FloatTag setValue(float value) {
        this.value = value;
        return this;
    }

    @Override
    public byte byteValue() {
        return (byte)((int)Math.floor(this.value) & 0xFF);
    }

    @Override
    public short shortValue() {
        return (short)((int)Math.floor(this.value) & 0xFFFF);
    }

    @Override
    public int intValue() {
        return (int)Math.floor(this.value);
    }

    @Override
    public long longValue() {
        return (long)Math.floor(this.value);
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Number numberValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.FLOAT;
    }

    @Override
    public FloatTag copy() {
        return new FloatTag(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatTag floatTag = (FloatTag)o;
        return Float.compare(floatTag.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.value));
    }

    @Override
    public String toString() {
        return "float(" + this.value + ")";
    }
}

