/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.Arrays;
import java.util.Iterator;
import net.lenni0451.mcstructs.nbt.NbtArray;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;

public class LongArrayTag
implements NbtTag,
NbtArray<LongArrayTag, LongTag, long[], Long> {
    private long[] value;

    public LongArrayTag() {
        this(new long[0]);
    }

    public LongArrayTag(ListTag<LongTag> list) {
        this.value = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.value[i] = list.get(i).getValue();
        }
    }

    public LongArrayTag(long[] value) {
        this.value = value;
    }

    @Override
    public long[] getValue() {
        return this.value;
    }

    @Override
    public LongArrayTag setValue(long[] value) {
        this.value = value;
        return this;
    }

    public long get(int index) {
        return this.value[index];
    }

    public LongArrayTag set(int index, long l) {
        this.value[index] = l;
        return this;
    }

    public LongArrayTag add(long l) {
        long[] newValue = new long[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = l;
        this.value = newValue;
        return this;
    }

    @Override
    public int getLength() {
        return this.value.length;
    }

    @Override
    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public ListTag<LongTag> toListTag() {
        ListTag<LongTag> listTag = new ListTag<LongTag>();
        for (long l : this.value) {
            listTag.add(new LongTag(l));
        }
        return listTag;
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.LONG_ARRAY;
    }

    @Override
    public LongArrayTag copy() {
        return new LongArrayTag((long[])this.value.clone());
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < LongArrayTag.this.value.length;
            }

            @Override
            public Long next() {
                return LongArrayTag.this.value[this.index++];
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongArrayTag that = (LongArrayTag)o;
        return Arrays.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public String toString() {
        String s = Arrays.toString(this.value);
        return "long[" + this.value.length + "](" + s.substring(1, s.length() - 1) + ")";
    }
}

