/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.utils;

import java.util.ArrayList;
import java.util.List;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;

public class NbtCodecUtils {
    public static final String MARKER_KEY = "";

    public static List<NbtTag> unwrapMarkers(ListTag<?> listTag) {
        ArrayList<NbtTag> tags = new ArrayList<NbtTag>(listTag.getValue());
        if (NbtType.COMPOUND.equals((Object)listTag.getType())) {
            for (int i = 0; i < tags.size(); ++i) {
                CompoundTag tag = ((NbtTag)tags.get(i)).asCompoundTag();
                Object wrapped = tag.get(MARKER_KEY);
                if (wrapped == null) continue;
                tags.set(i, (NbtTag)wrapped);
            }
        }
        return tags;
    }

    public static ListTag<NbtTag> wrapMarkers(List<NbtTag> tags) {
        ListTag<NbtTag> listTag = new ListTag<NbtTag>(NbtType.COMPOUND);
        for (NbtTag tag : tags) {
            boolean isMarker;
            boolean bl = isMarker = tag.isCompoundTag() && tag.asCompoundTag().size() == 1 && tag.asCompoundTag().contains(MARKER_KEY);
            if (tag.isCompoundTag() && !isMarker) {
                listTag.add(tag.asCompoundTag());
                continue;
            }
            listTag.add(new CompoundTag().add(MARKER_KEY, tag));
        }
        return listTag;
    }

    public static ListTag<NbtTag> wrapIfRequired(List<NbtTag> tags) {
        NbtType type = null;
        for (NbtTag tag : tags) {
            if (type == null) {
                type = tag.getNbtType();
                continue;
            }
            if (type == tag.getNbtType()) continue;
            return NbtCodecUtils.wrapMarkers(tags);
        }
        return new ListTag<NbtTag>(type, tags);
    }
}

