/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.impl;

import java.io.DataInput;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.NbtReadTracker;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

@ParametersAreNonnullByDefault
public interface NbtReader {
    @Nonnull
    public NbtType readType(DataInput var1, NbtReadTracker var2) throws IOException;

    @Nonnull
    public NbtHeader readHeader(DataInput var1, NbtReadTracker var2) throws IOException;

    @Nonnull
    default public NbtTag read(NbtType type, DataInput in, NbtReadTracker readTracker) throws IOException {
        switch (type) {
            case BYTE: {
                return this.readByte(in, readTracker);
            }
            case SHORT: {
                return this.readShort(in, readTracker);
            }
            case INT: {
                return this.readInt(in, readTracker);
            }
            case LONG: {
                return this.readLong(in, readTracker);
            }
            case FLOAT: {
                return this.readFloat(in, readTracker);
            }
            case DOUBLE: {
                return this.readDouble(in, readTracker);
            }
            case BYTE_ARRAY: {
                return this.readByteArray(in, readTracker);
            }
            case STRING: {
                return this.readString(in, readTracker);
            }
            case LIST: {
                return this.readList(in, readTracker);
            }
            case COMPOUND: {
                return this.readCompound(in, readTracker);
            }
            case INT_ARRAY: {
                return this.readIntArray(in, readTracker);
            }
            case LONG_ARRAY: {
                return this.readLongArray(in, readTracker);
            }
        }
        throw new IOException("Unknown tag type: " + (Object)((Object)type));
    }

    @Nonnull
    default public ByteTag readByte(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support byte tags");
    }

    @Nonnull
    default public ShortTag readShort(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support short tags");
    }

    @Nonnull
    default public IntTag readInt(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support int tags");
    }

    @Nonnull
    default public LongTag readLong(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support long tags");
    }

    @Nonnull
    default public FloatTag readFloat(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support float tags");
    }

    @Nonnull
    default public DoubleTag readDouble(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support double tags");
    }

    @Nonnull
    default public ByteArrayTag readByteArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support byte array tags");
    }

    @Nonnull
    default public StringTag readString(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support string tags");
    }

    @Nonnull
    default public ListTag<?> readList(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support list tags");
    }

    @Nonnull
    default public CompoundTag readCompound(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support compound tags");
    }

    @Nonnull
    default public IntArrayTag readIntArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support int array tags");
    }

    @Nonnull
    default public LongArrayTag readLongArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support long array tags");
    }
}

