/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.impl;

import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

@ParametersAreNonnullByDefault
public interface NbtWriter {
    public void writeType(DataOutput var1, NbtType var2) throws IOException;

    public void writeHeader(DataOutput var1, NbtHeader var2) throws IOException;

    default public void write(DataOutput out, NbtTag tag) throws IOException {
        if (tag instanceof ByteTag) {
            this.writeByte(out, (ByteTag)tag);
        } else if (tag instanceof ShortTag) {
            this.writeShort(out, (ShortTag)tag);
        } else if (tag instanceof IntTag) {
            this.writeInt(out, (IntTag)tag);
        } else if (tag instanceof LongTag) {
            this.writeLong(out, (LongTag)tag);
        } else if (tag instanceof FloatTag) {
            this.writeFloat(out, (FloatTag)tag);
        } else if (tag instanceof DoubleTag) {
            this.writeDouble(out, (DoubleTag)tag);
        } else if (tag instanceof ByteArrayTag) {
            this.writeByteArray(out, (ByteArrayTag)tag);
        } else if (tag instanceof StringTag) {
            this.writeString(out, (StringTag)tag);
        } else if (tag instanceof ListTag) {
            this.writeList(out, (ListTag)tag);
        } else if (tag instanceof CompoundTag) {
            this.writeCompound(out, (CompoundTag)tag);
        } else if (tag instanceof IntArrayTag) {
            this.writeIntArray(out, (IntArrayTag)tag);
        } else if (tag instanceof LongArrayTag) {
            this.writeLongArray(out, (LongArrayTag)tag);
        } else {
            throw new IllegalArgumentException("Unknown tag type: " + tag.getClass().getName());
        }
    }

    default public void writeByte(DataOutput out, ByteTag tag) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support byte tags");
    }

    default public void writeShort(DataOutput out, ShortTag tag) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support short tags");
    }

    default public void writeInt(DataOutput out, IntTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support int tags");
    }

    default public void writeLong(DataOutput out, LongTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support long tags");
    }

    default public void writeFloat(DataOutput out, FloatTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support float tags");
    }

    default public void writeDouble(DataOutput out, DoubleTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support double tags");
    }

    default public void writeByteArray(DataOutput out, ByteArrayTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support byte array tags");
    }

    default public void writeString(DataOutput out, StringTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support string tags");
    }

    default public void writeList(DataOutput out, ListTag<?> value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support list tags");
    }

    default public void writeCompound(DataOutput out, CompoundTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support compound tags");
    }

    default public void writeIntArray(DataOutput out, IntArrayTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support int array tags");
    }

    default public void writeLongArray(DataOutput out, LongArrayTag value) throws IOException {
        throw new UnsupportedOperationException("This Nbt version does not support long array tags");
    }
}

