/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.impl.v1_0_0;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.exceptions.NbtReadException;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.NbtReadTracker;
import net.lenni0451.mcstructs.nbt.io.impl.NbtReader;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

@ParametersAreNonnullByDefault
public class NbtReader_v1_0_0
implements NbtReader {
    @Override
    @Nonnull
    public NbtType readType(DataInput in, NbtReadTracker readTracker) throws IOException {
        byte id = in.readByte();
        NbtType type = NbtType.byId(id);
        if (type == null) {
            throw new IOException("Unknown Nbt type: " + id);
        }
        return type;
    }

    @Override
    @Nonnull
    public NbtHeader readHeader(DataInput in, NbtReadTracker readTracker) throws IOException {
        NbtType type = this.readType(in, readTracker);
        if (NbtType.END.equals((Object)type)) {
            return NbtHeader.END;
        }
        return new NbtHeader(type, in.readUTF());
    }

    @Override
    @Nonnull
    public ByteTag readByte(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(9L);
        return new ByteTag(in.readByte());
    }

    @Override
    @Nonnull
    public ShortTag readShort(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(10L);
        return new ShortTag(in.readShort());
    }

    @Override
    @Nonnull
    public IntTag readInt(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(12L);
        return new IntTag(in.readInt());
    }

    @Override
    @Nonnull
    public LongTag readLong(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(16L);
        return new LongTag(in.readLong());
    }

    @Override
    @Nonnull
    public FloatTag readFloat(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(12L);
        return new FloatTag(in.readFloat());
    }

    @Override
    @Nonnull
    public DoubleTag readDouble(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(16L);
        return new DoubleTag(in.readDouble());
    }

    @Override
    @Nonnull
    public ByteArrayTag readByteArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(24L);
        int length = in.readInt();
        readTracker.read(length, 1L);
        byte[] value = new byte[length];
        in.readFully(value);
        return new ByteArrayTag(value);
    }

    @Override
    @Nonnull
    public StringTag readString(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(36L);
        String value = in.readUTF();
        readTracker.read(value.length(), 2L);
        return new StringTag(value);
    }

    @Override
    @Nonnull
    public ListTag<?> readList(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(37L);
        byte typeId = in.readByte();
        int count = in.readInt();
        if (typeId == NbtType.END.getId() && count > 0) {
            throw new NbtReadException("ListNbt with type END and count > 0");
        }
        readTracker.read(count, 4L);
        NbtType type = NbtType.byId(typeId);
        ArrayList<NbtTag> value = new ArrayList<NbtTag>(Math.min(count, 512));
        for (int i = 0; i < count; ++i) {
            readTracker.pushDepth();
            NbtTag tag = this.read(type, in, readTracker);
            readTracker.popDepth();
            value.add(tag);
        }
        return new ListTag(type, value);
    }

    @Override
    @Nonnull
    public CompoundTag readCompound(DataInput in, NbtReadTracker readTracker) throws IOException {
        NbtHeader header;
        readTracker.read(48L);
        HashMap<String, NbtTag> value = new HashMap<String, NbtTag>();
        while (!(header = this.readHeader(in, readTracker)).isEnd()) {
            readTracker.read(28L);
            readTracker.read(header.getName().length(), 2L);
            readTracker.pushDepth();
            NbtTag tag = this.read(header.getType(), in, readTracker);
            readTracker.popDepth();
            if (value.put(header.getName(), tag) == null) continue;
            readTracker.read(36L);
        }
        return new CompoundTag(value);
    }
}

