/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.internal;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPOutputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.impl.NbtWriter;

@ParametersAreNonnullByDefault
public interface NbtWriteWrapper {
    public NbtWriter getWriter();

    default public void writeFile(File f, String name, NbtTag tag) throws IOException {
        this.writeFile(f, name, tag, false);
    }

    default public void writeCompressedFile(File f, String name, NbtTag tag) throws IOException {
        this.writeFile(f, name, tag, true);
    }

    default public void writeFile(File f, String name, NbtTag tag, boolean compressed) throws IOException {
        try (OutputStream fos = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            this.write(fos, name, tag, compressed);
        }
    }

    @WillClose
    default public void write(OutputStream os, String name, NbtTag tag, boolean compressed) throws IOException {
        if (compressed) {
            try (GZIPOutputStream gos = new GZIPOutputStream(os);){
                this.write(new DataOutputStream(gos), name, tag);
            }
        } else {
            this.write(new DataOutputStream(os), name, tag);
        }
    }

    @WillNotClose
    default public void write(DataOutput out, String name, NbtTag tag) throws IOException {
        this.getWriter().writeHeader(out, new NbtHeader(tag.getNbtType(), name));
        this.getWriter().write(out, tag);
    }

    @WillNotClose
    default public void writeUnnamed(DataOutput out, NbtTag tag) throws IOException {
        this.getWriter().writeType(out, tag.getNbtType());
        this.getWriter().write(out, tag);
    }
}

