/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.nbt.NbtNumber;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;
import net.lenni0451.mcstructs.nbt.utils.ObjectTagConverter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CompoundTag
implements NbtTag,
Iterable<Map.Entry<String, NbtTag>> {
    private Map<String, NbtTag> value;

    public CompoundTag() {
        this.value = new HashMap<String, NbtTag>();
    }

    public CompoundTag(Map<String, NbtTag> value) {
        this.value = value;
    }

    public Map<String, NbtTag> getValue() {
        return this.value;
    }

    public CompoundTag setValue(Map<String, NbtTag> value) {
        this.value = value;
        return this;
    }

    public int size() {
        return this.value.size();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean contains(String key) {
        return this.value.containsKey(key);
    }

    public boolean contains(String key, NbtType type) {
        Object tag = this.get(key);
        if (tag == null) {
            return false;
        }
        if (type.isNumber() && tag.getNbtType().isNumber()) {
            return true;
        }
        return tag.getNbtType().equals((Object)type);
    }

    public boolean containsExact(String key, NbtType type) {
        Object tag = this.get(key);
        if (tag == null) {
            return false;
        }
        return tag.getNbtType().equals((Object)type);
    }

    @Nullable
    public <T extends NbtTag> T get(String key) {
        return (T)this.value.get(key);
    }

    public <T extends NbtTag> T get(String key, T def) {
        T t = this.get(key);
        if (t == null) {
            return def;
        }
        return t;
    }

    public CompoundTag add(String key, NbtTag tag) {
        this.value.put(key, tag);
        return this;
    }

    public CompoundTag add(String key, Object o) {
        return this.add(key, ObjectTagConverter.convert(o));
    }

    public CompoundTag addAll(CompoundTag tag) {
        this.value.putAll(tag.getValue());
        return this;
    }

    @Nullable
    public NbtTag remove(String key) {
        return this.value.remove(key);
    }

    public boolean getBoolean(String key) {
        if (this.contains(key, NbtType.BYTE)) {
            return ((NbtNumber)this.get(key)).byteValue() != 0;
        }
        return false;
    }

    public boolean getBoolean(String key, boolean def) {
        if (this.contains(key, NbtType.BYTE)) {
            return ((NbtNumber)this.get(key)).byteValue() != 0;
        }
        return def;
    }

    public CompoundTag addBoolean(String key, boolean b) {
        return this.add(key, new ByteTag((byte)(b ? 1 : 0)));
    }

    public byte getByte(String key) {
        if (this.contains(key, NbtType.BYTE)) {
            return ((NbtNumber)this.get(key)).byteValue();
        }
        return 0;
    }

    public byte getByte(String key, byte def) {
        if (this.contains(key, NbtType.BYTE)) {
            return ((NbtNumber)this.get(key)).byteValue();
        }
        return def;
    }

    public CompoundTag addByte(String key, byte b) {
        return this.add(key, new ByteTag(b));
    }

    public short getShort(String key) {
        if (this.contains(key, NbtType.SHORT)) {
            return ((NbtNumber)this.get(key)).shortValue();
        }
        return 0;
    }

    public short getShort(String key, short def) {
        if (this.contains(key, NbtType.SHORT)) {
            return ((NbtNumber)this.get(key)).shortValue();
        }
        return def;
    }

    public CompoundTag addShort(String key, short s) {
        return this.add(key, new ShortTag(s));
    }

    public int getInt(String key) {
        if (this.contains(key, NbtType.INT)) {
            return ((NbtNumber)this.get(key)).intValue();
        }
        return 0;
    }

    public int getInt(String key, int def) {
        if (this.contains(key, NbtType.INT)) {
            return ((NbtNumber)this.get(key)).intValue();
        }
        return def;
    }

    public CompoundTag addInt(String key, int i) {
        return this.add(key, new IntTag(i));
    }

    public long getLong(String key) {
        if (this.contains(key, NbtType.LONG)) {
            return ((NbtNumber)this.get(key)).longValue();
        }
        return 0L;
    }

    public long getLong(String key, long def) {
        if (this.contains(key, NbtType.LONG)) {
            return ((NbtNumber)this.get(key)).longValue();
        }
        return def;
    }

    public CompoundTag addLong(String key, long l) {
        return this.add(key, new LongTag(l));
    }

    public float getFloat(String key) {
        if (this.contains(key, NbtType.FLOAT)) {
            return ((NbtNumber)this.get(key)).floatValue();
        }
        return 0.0f;
    }

    public float getFloat(String key, float def) {
        if (this.contains(key, NbtType.FLOAT)) {
            return ((NbtNumber)this.get(key)).floatValue();
        }
        return def;
    }

    public CompoundTag addFloat(String key, float f) {
        return this.add(key, new FloatTag(f));
    }

    public double getDouble(String key) {
        if (this.contains(key, NbtType.DOUBLE)) {
            return ((NbtNumber)this.get(key)).doubleValue();
        }
        return 0.0;
    }

    public double getDouble(String key, double def) {
        if (this.contains(key, NbtType.DOUBLE)) {
            return ((NbtNumber)this.get(key)).doubleValue();
        }
        return def;
    }

    public CompoundTag addDouble(String key, double d) {
        return this.add(key, new DoubleTag(d));
    }

    public byte[] getByteArray(String key) {
        if (this.contains(key, NbtType.BYTE_ARRAY)) {
            return ((ByteArrayTag)this.get(key)).getValue();
        }
        return new byte[0];
    }

    public byte[] getByteArray(String key, byte[] def) {
        if (this.contains(key, NbtType.BYTE_ARRAY)) {
            return ((ByteArrayTag)this.get(key)).getValue();
        }
        return def;
    }

    public CompoundTag addByteArray(String key, byte ... bytes) {
        return this.add(key, new ByteArrayTag(bytes));
    }

    public String getString(String key) {
        if (this.contains(key, NbtType.STRING)) {
            return ((StringTag)this.get(key)).getValue();
        }
        return "";
    }

    public String getString(String key, String def) {
        if (this.contains(key, NbtType.STRING)) {
            return ((StringTag)this.get(key)).getValue();
        }
        return def;
    }

    public CompoundTag addString(String key, String s) {
        return this.add(key, new StringTag(s));
    }

    public <T extends NbtTag> ListTag<T> getList(String key) {
        if (this.contains(key, NbtType.LIST)) {
            return (ListTag)this.get(key);
        }
        return new ListTag();
    }

    public <T extends NbtTag> ListTag<T> getList(String key, ListTag<T> def) {
        if (this.contains(key, NbtType.LIST)) {
            return (ListTag)this.get(key);
        }
        return def;
    }

    public <T extends NbtTag> ListTag<T> getList(String key, NbtType type) {
        if (this.contains(key, NbtType.LIST)) {
            ListTag list = (ListTag)this.get(key);
            if (!list.canAdd(type)) {
                return new ListTag(type);
            }
            return list;
        }
        return new ListTag(type);
    }

    public <T extends NbtTag> ListTag<T> getList(String key, NbtType type, ListTag<T> def) {
        if (this.contains(key, NbtType.LIST)) {
            ListTag list = (ListTag)this.get(key);
            if (!list.canAdd(type)) {
                return def;
            }
            return list;
        }
        return def;
    }

    public CompoundTag addList(String key, ListTag<?> list) {
        return this.add(key, list);
    }

    public <T extends NbtTag> void addList(String key, T ... items) {
        if (items.length == 0) {
            this.add(key, new ListTag());
        } else {
            ArrayList list = new ArrayList();
            Collections.addAll(list, items);
            this.add(key, new ListTag(list));
        }
    }

    public CompoundTag addList(String key, Object ... items) {
        if (items.length == 0) {
            this.add(key, new ListTag());
        } else {
            ArrayList<NbtTag> list = new ArrayList<NbtTag>();
            for (Object item : items) {
                list.add(ObjectTagConverter.convert(item));
            }
            this.add(key, new ListTag(list));
        }
        return this;
    }

    public CompoundTag getCompound(String key) {
        if (this.contains(key, NbtType.COMPOUND)) {
            return (CompoundTag)this.get(key);
        }
        return new CompoundTag();
    }

    public CompoundTag getCompound(String key, CompoundTag def) {
        if (this.contains(key, NbtType.COMPOUND)) {
            return (CompoundTag)this.get(key);
        }
        return def;
    }

    public CompoundTag addCompound(String key, CompoundTag compound) {
        return this.add(key, compound);
    }

    public int[] getIntArray(String key) {
        if (this.contains(key, NbtType.INT_ARRAY)) {
            return ((IntArrayTag)this.get(key)).getValue();
        }
        return new int[0];
    }

    public int[] getIntArray(String key, int[] def) {
        if (this.contains(key, NbtType.INT_ARRAY)) {
            return ((IntArrayTag)this.get(key)).getValue();
        }
        return def;
    }

    public CompoundTag addIntArray(String key, int ... ints) {
        return this.add(key, new IntArrayTag(ints));
    }

    public long[] getLongArray(String key) {
        if (this.contains(key, NbtType.LONG_ARRAY)) {
            return ((LongArrayTag)this.get(key)).getValue();
        }
        return new long[0];
    }

    public long[] getLongArray(String key, long[] def) {
        if (this.contains(key, NbtType.LONG_ARRAY)) {
            return ((LongArrayTag)this.get(key)).getValue();
        }
        return def;
    }

    public CompoundTag addLongArray(String key, long ... longs) {
        return this.add(key, new LongArrayTag(longs));
    }

    public boolean trim() {
        if (this.value.isEmpty()) {
            return true;
        }
        this.value.entrySet().removeIf(entry -> {
            NbtTag tag = (NbtTag)entry.getValue();
            if (tag instanceof ByteTag) {
                return ((ByteTag)tag).getValue() == 0;
            }
            if (tag instanceof ShortTag) {
                return ((ShortTag)tag).getValue() == 0;
            }
            if (tag instanceof IntTag) {
                return ((IntTag)tag).getValue() == 0;
            }
            if (tag instanceof LongTag) {
                return ((LongTag)tag).getValue() == 0L;
            }
            if (tag instanceof FloatTag) {
                return ((FloatTag)tag).getValue() == 0.0f;
            }
            if (tag instanceof DoubleTag) {
                return ((DoubleTag)tag).getValue() == 0.0;
            }
            if (tag instanceof ByteArrayTag) {
                return ((ByteArrayTag)tag).isEmpty();
            }
            if (tag instanceof StringTag) {
                return ((StringTag)tag).getValue().isEmpty();
            }
            if (tag instanceof ListTag) {
                return ((ListTag)tag).trim();
            }
            if (tag instanceof CompoundTag) {
                return ((CompoundTag)tag).trim();
            }
            if (tag instanceof IntArrayTag) {
                return ((IntArrayTag)tag).isEmpty();
            }
            if (tag instanceof LongArrayTag) {
                return ((LongArrayTag)tag).isEmpty();
            }
            return false;
        });
        return this.value.isEmpty();
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.COMPOUND;
    }

    @Override
    public CompoundTag copy() {
        HashMap<String, NbtTag> value = new HashMap<String, NbtTag>();
        for (Map.Entry<String, NbtTag> entry : this.value.entrySet()) {
            value.put(entry.getKey(), entry.getValue().copy());
        }
        return new CompoundTag(value);
    }

    @Override
    public Iterator<Map.Entry<String, NbtTag>> iterator() {
        return this.value.entrySet().iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundTag that = (CompoundTag)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public String toString() {
        return "Compound[" + this.value.size() + "]" + this.value;
    }
}

