/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;

public class ListTag<T extends NbtTag>
implements NbtTag,
Iterable<T> {
    private NbtType type;
    private List<T> value;

    public ListTag() {
        this(null, new ArrayList());
    }

    public ListTag(NbtType type) {
        this(type, new ArrayList());
    }

    public ListTag(List<T> list) {
        this(null, list);
    }

    public ListTag(NbtType type, List<T> value) {
        this.type = type == null && !value.isEmpty() ? ((NbtTag)value.get(0)).getNbtType() : type;
        if (this.type != null && !value.isEmpty() && value.stream().anyMatch(tag -> !tag.getNbtType().equals((Object)this.type))) {
            throw new IllegalArgumentException("Tried to create list with multiple Nbt types");
        }
        this.value = value;
    }

    @Nullable
    public NbtType getType() {
        return this.type;
    }

    public List<T> getValue() {
        return this.value;
    }

    public ListTag<T> setValue(List<T> value) {
        this.value = value;
        return this;
    }

    public T get(int index) {
        return (T)((NbtTag)this.value.get(index));
    }

    public ListTag<T> add(T tag) {
        this.check(tag);
        this.value.add(tag);
        return this;
    }

    public ListTag<T> set(int index, T tag) {
        this.check(tag);
        this.value.set(index, tag);
        return this;
    }

    public ListTag<T> remove(T tag) {
        this.check(tag);
        this.value.remove(tag);
        return this;
    }

    public boolean canAdd(NbtTag tag) {
        if (this.type == null || this.value.isEmpty()) {
            return true;
        }
        return this.type.equals((Object)tag.getNbtType());
    }

    public boolean canAdd(NbtType type) {
        if (this.type == null || this.value.isEmpty()) {
            return true;
        }
        return this.type.equals((Object)type);
    }

    public boolean trim() {
        if (this.value.isEmpty()) {
            return true;
        }
        if (NbtType.COMPOUND.equals((Object)this.type)) {
            this.value.forEach(tag -> ((CompoundTag)tag).trim());
        } else if (NbtType.LIST.equals((Object)this.type)) {
            this.value.forEach(tag -> ((ListTag)tag).trim());
        }
        return false;
    }

    public int size() {
        return this.value.size();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    private void check(T tag) {
        if (this.type == null || this.value.isEmpty()) {
            this.type = tag.getNbtType();
            this.value.clear();
        } else if (!this.type.equals((Object)tag.getNbtType())) {
            throw new IllegalArgumentException("Can't add " + tag.getClass().getSimpleName() + " to a " + this.type.name() + " list");
        }
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.LIST;
    }

    @Override
    public ListTag copy() {
        ArrayList<NbtTag> value = new ArrayList<NbtTag>();
        for (NbtTag val : this.value) {
            value.add(val.copy());
        }
        return new ListTag(value);
    }

    @Override
    public Iterator<T> iterator() {
        return this.value.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTag listTag = (ListTag)o;
        if (!Objects.equals((Object)this.type, (Object)listTag.type)) {
            if (Objects.isNull((Object)this.type) && Objects.equals((Object)NbtType.END, (Object)listTag.type)) {
                return true;
            }
            return Objects.isNull((Object)listTag.type) && Objects.equals((Object)NbtType.END, (Object)this.type);
        }
        return Objects.equals(this.value, listTag.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    @Override
    public String toString() {
        String list = this.value.toString();
        list = list.substring(1, list.length() - 1);
        return "List[" + this.value.size() + "](" + list + ")";
    }
}

