/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.utils;

import java.util.List;
import java.util.Map;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.exceptions.UnknownTagTypeException;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

public class ObjectTagConverter {
    public static ListTag<?> convertList(List<?> list) {
        ListTag<NbtTag> tag = new ListTag<NbtTag>();
        for (Object o : list) {
            tag.add(ObjectTagConverter.convert(o));
        }
        return tag;
    }

    public static CompoundTag convertMap(Map<?, ?> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            tag.add(entry.getKey().toString(), ObjectTagConverter.convert(entry.getValue()));
        }
        return tag;
    }

    public static NbtTag convert(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof NbtTag) {
            return (NbtTag)o;
        }
        if (o instanceof Byte) {
            return new ByteTag((Byte)o);
        }
        if (o instanceof Short) {
            return new ShortTag((Short)o);
        }
        if (o instanceof Integer) {
            return new IntTag((Integer)o);
        }
        if (o instanceof Long) {
            return new LongTag((Long)o);
        }
        if (o instanceof Float) {
            return new FloatTag(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new DoubleTag((Double)o);
        }
        if (o instanceof byte[]) {
            return new ByteArrayTag((byte[])o);
        }
        if (o instanceof String) {
            return new StringTag((String)o);
        }
        if (o instanceof List) {
            return ObjectTagConverter.convertList((List)o);
        }
        if (o instanceof Map) {
            return ObjectTagConverter.convertMap((Map)o);
        }
        if (o instanceof int[]) {
            return new IntArrayTag((int[])o);
        }
        if (o instanceof long[]) {
            return new LongArrayTag((long[])o);
        }
        throw new UnknownTagTypeException(o.getClass());
    }
}

