/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.components;

import lombok.Generated;
import net.lenni0451.mcstructs.converter.DataConverter;
import net.lenni0451.mcstructs.converter.SerializedData;
import net.lenni0451.mcstructs.converter.impl.v1_21_5.NbtConverter_v1_21_5;
import net.lenni0451.mcstructs.converter.model.Result;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.core.utils.ToString;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.text.TextComponent;
import net.lenni0451.mcstructs.text.font.AtlasSpriteFont;
import net.lenni0451.mcstructs.text.font.FontDescription;
import net.lenni0451.mcstructs.text.font.PlayerSpriteFont;

public class ObjectComponent
extends TextComponent {
    private ObjectInfo objectInfo;

    @Override
    public String asSingleString() {
        return this.objectInfo.getDescription();
    }

    @Override
    public TextComponent copy() {
        return new ObjectComponent(this.objectInfo);
    }

    @Override
    public String toString() {
        return ToString.of((Object)this).add("siblings", this.getSiblings(), siblings -> !siblings.isEmpty()).add("style", (Object)this.getStyle(), style -> !style.isEmpty()).add("objectInfo", (Object)this.objectInfo).toString();
    }

    @Generated
    public ObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    @Generated
    public void setObjectInfo(ObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
    }

    @Generated
    public ObjectComponent(ObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectComponent)) {
            return false;
        }
        ObjectComponent other = (ObjectComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectInfo this$objectInfo = this.getObjectInfo();
        ObjectInfo other$objectInfo = other.getObjectInfo();
        return !(this$objectInfo == null ? other$objectInfo != null : !this$objectInfo.equals(other$objectInfo));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObjectComponent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ObjectInfo $objectInfo = this.getObjectInfo();
        result = result * 59 + ($objectInfo == null ? 43 : $objectInfo.hashCode());
        return result;
    }

    public static class PlayerSprite
    implements ObjectInfo {
        private SerializedData<?> profile;
        private boolean hat;

        @Override
        public FontDescription getUpdatedFont() {
            return new PlayerSpriteFont(this.profile, this.hat);
        }

        @Override
        public String getDescription() {
            String profileName = (String)this.profile.convert((DataConverter)NbtConverter_v1_21_5.INSTANCE).map(NbtTag::asCompoundTag).mapResult(compound -> {
                String name = compound.getString("name", null);
                return name == null ? Result.error((String)"No name in profile") : Result.success((Object)name);
            }).orElse(null);
            if (profileName == null) {
                return "[unknown player head]";
            }
            return "[" + profileName + " head]";
        }

        @Override
        public String toString() {
            return ToString.of((Object)this).add("profile", this.profile).add("hat", (Object)this.hat).toString();
        }

        @Generated
        public SerializedData<?> getProfile() {
            return this.profile;
        }

        @Generated
        public boolean isHat() {
            return this.hat;
        }

        @Generated
        public void setProfile(SerializedData<?> profile) {
            this.profile = profile;
        }

        @Generated
        public void setHat(boolean hat) {
            this.hat = hat;
        }

        @Generated
        public PlayerSprite(SerializedData<?> profile, boolean hat) {
            this.profile = profile;
            this.hat = hat;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerSprite)) {
                return false;
            }
            PlayerSprite other = (PlayerSprite)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHat() != other.isHat()) {
                return false;
            }
            SerializedData<?> this$profile = this.getProfile();
            SerializedData<?> other$profile = other.getProfile();
            return !(this$profile == null ? other$profile != null : !this$profile.equals(other$profile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PlayerSprite;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHat() ? 79 : 97);
            SerializedData<?> $profile = this.getProfile();
            result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
            return result;
        }
    }

    public static class AtlasSprite
    implements ObjectInfo {
        public static final Identifier DEFAULT_ATLAS = Identifier.defaultNamespace((String)"blocks");
        private Identifier atlas;
        private Identifier sprite;

        public AtlasSprite(Identifier sprite) {
            this.atlas = DEFAULT_ATLAS;
            this.sprite = sprite;
        }

        @Override
        public FontDescription getUpdatedFont() {
            return new AtlasSpriteFont(this.atlas, this.sprite);
        }

        @Override
        public String getDescription() {
            String shortSprite = Identifier.stripDefaultNamespace((Identifier)this.sprite);
            if (this.atlas.equals((Object)DEFAULT_ATLAS)) {
                return "[" + shortSprite + "]";
            }
            String shortAtlas = Identifier.stripDefaultNamespace((Identifier)this.atlas);
            return "[" + shortAtlas + "@" + shortSprite + "]";
        }

        @Override
        public String toString() {
            return ToString.of((Object)this).add("atlas", (Object)this.atlas).add("sprite", (Object)this.sprite).toString();
        }

        @Generated
        public Identifier getAtlas() {
            return this.atlas;
        }

        @Generated
        public Identifier getSprite() {
            return this.sprite;
        }

        @Generated
        public void setAtlas(Identifier atlas) {
            this.atlas = atlas;
        }

        @Generated
        public void setSprite(Identifier sprite) {
            this.sprite = sprite;
        }

        @Generated
        public AtlasSprite(Identifier atlas, Identifier sprite) {
            this.atlas = atlas;
            this.sprite = sprite;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AtlasSprite)) {
                return false;
            }
            AtlasSprite other = (AtlasSprite)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Identifier this$atlas = this.getAtlas();
            Identifier other$atlas = other.getAtlas();
            if (this$atlas == null ? other$atlas != null : !this$atlas.equals(other$atlas)) {
                return false;
            }
            Identifier this$sprite = this.getSprite();
            Identifier other$sprite = other.getSprite();
            return !(this$sprite == null ? other$sprite != null : !this$sprite.equals(other$sprite));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AtlasSprite;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Identifier $atlas = this.getAtlas();
            result = result * 59 + ($atlas == null ? 43 : $atlas.hashCode());
            Identifier $sprite = this.getSprite();
            result = result * 59 + ($sprite == null ? 43 : $sprite.hashCode());
            return result;
        }
    }

    public static interface ObjectInfo {
        public FontDescription getUpdatedFont();

        public String getDescription();

        public String toString();
    }
}

