/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.events.click;

import java.net.URI;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.converter.SerializedData;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.text.events.click.ClickEventAction;
import net.lenni0451.mcstructs.text.events.click.types.ChangePageClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.CopyToClipboardClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.CustomClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.OpenFileClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.OpenUrlClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.RunCommandClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.ShowDialogClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.SuggestCommandClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.TwitchUserInfoClickEvent;

public abstract class ClickEvent {
    protected final ClickEventAction action;

    public static OpenUrlClickEvent openUrl(URI url) {
        return new OpenUrlClickEvent(url);
    }

    public static OpenFileClickEvent openFile(String path) {
        return new OpenFileClickEvent(path);
    }

    public static RunCommandClickEvent runCommand(String command) {
        return new RunCommandClickEvent(command);
    }

    public static TwitchUserInfoClickEvent twitchUserInfo(String user) {
        return new TwitchUserInfoClickEvent(user);
    }

    public static SuggestCommandClickEvent suggestCommand(String command) {
        return new SuggestCommandClickEvent(command);
    }

    public static ChangePageClickEvent changePage(int page) {
        return new ChangePageClickEvent(page);
    }

    public static CopyToClipboardClickEvent copyToClipboard(String value) {
        return new CopyToClipboardClickEvent(value);
    }

    public static ShowDialogClickEvent showDialog(SerializedData<?> dialogData) {
        return new ShowDialogClickEvent(dialogData);
    }

    public static CustomClickEvent custom(Identifier id, @Nullable NbtTag payload) {
        return new CustomClickEvent(id, payload);
    }

    public ClickEvent(ClickEventAction action) {
        this.action = action;
    }

    public ClickEventAction getAction() {
        return this.action;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

