/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.mcstructs.converter.DataConverter;
import net.lenni0451.mcstructs.converter.codec.Codec;
import net.lenni0451.mcstructs.converter.impl.v1_20_3.JsonConverter_v1_20_3;
import net.lenni0451.mcstructs.converter.impl.v1_20_3.NbtConverter_v1_20_3;
import net.lenni0451.mcstructs.converter.impl.v1_20_5.JsonConverter_v1_20_5;
import net.lenni0451.mcstructs.converter.impl.v1_21_5.NbtConverter_v1_21_5;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.snbt.SNbt;
import net.lenni0451.mcstructs.snbt.exceptions.SNbtDeserializeException;
import net.lenni0451.mcstructs.snbt.exceptions.SNbtSerializeException;
import net.lenni0451.mcstructs.text.Style;
import net.lenni0451.mcstructs.text.TextComponent;
import net.lenni0451.mcstructs.text.serializer.TextComponentSerializer;
import net.lenni0451.mcstructs.text.serializer.v1_20_3.StyleCodecs_v1_20_3;
import net.lenni0451.mcstructs.text.serializer.v1_20_3.TextCodecs_v1_20_3;
import net.lenni0451.mcstructs.text.serializer.v1_20_5.StyleCodecs_v1_20_5;
import net.lenni0451.mcstructs.text.serializer.v1_20_5.TextCodecs_v1_20_5;
import net.lenni0451.mcstructs.text.serializer.v1_21_2.StyleCodecs_v1_21_2;
import net.lenni0451.mcstructs.text.serializer.v1_21_2.TextCodecs_v1_21_2;
import net.lenni0451.mcstructs.text.serializer.v1_21_4.StyleCodecs_v1_21_4;
import net.lenni0451.mcstructs.text.serializer.v1_21_4.TextCodecs_v1_21_4;
import net.lenni0451.mcstructs.text.serializer.v1_21_5.StyleCodecs_v1_21_5;
import net.lenni0451.mcstructs.text.serializer.v1_21_5.TextCodecs_v1_21_5;
import net.lenni0451.mcstructs.text.serializer.v1_21_6.StyleCodecs_v1_21_6;
import net.lenni0451.mcstructs.text.serializer.v1_21_6.TextCodecs_v1_21_6;
import net.lenni0451.mcstructs.text.serializer.v1_21_9.StyleCodecs_v1_21_9;
import net.lenni0451.mcstructs.text.serializer.v1_21_9.TextCodecs_v1_21_9;
import net.lenni0451.mcstructs.text.serializer.verify.TextVerifier;
import net.lenni0451.mcstructs.text.serializer.verify.VerifyingConverter;

@ParametersAreNonnullByDefault
public class TextComponentCodec {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final TextComponentCodec V1_20_3 = new TextComponentCodec(() -> SNbt.V1_14, () -> TextCodecs_v1_20_3.TEXT, () -> StyleCodecs_v1_20_3.CODEC, (DataConverter<JsonElement>)JsonConverter_v1_20_3.INSTANCE, (DataConverter<NbtTag>)NbtConverter_v1_20_3.INSTANCE);
    public static final TextComponentCodec V1_20_5 = new TextComponentCodec(() -> SNbt.V1_14, () -> TextCodecs_v1_20_5.TEXT, () -> StyleCodecs_v1_20_5.CODEC, (DataConverter<JsonElement>)JsonConverter_v1_20_5.INSTANCE, (DataConverter<NbtTag>)NbtConverter_v1_20_3.INSTANCE);
    public static final TextComponentCodec V1_21_2 = new TextComponentCodec(() -> SNbt.V1_14, () -> TextCodecs_v1_21_2.TEXT, () -> StyleCodecs_v1_21_2.CODEC, (DataConverter<JsonElement>)JsonConverter_v1_20_5.INSTANCE, (DataConverter<NbtTag>)NbtConverter_v1_20_3.INSTANCE);
    public static final TextComponentCodec V1_21_4 = new TextComponentCodec(() -> SNbt.V1_14, () -> TextCodecs_v1_21_4.TEXT, () -> StyleCodecs_v1_21_4.CODEC, (DataConverter<JsonElement>)JsonConverter_v1_20_5.INSTANCE, (DataConverter<NbtTag>)NbtConverter_v1_20_3.INSTANCE);
    public static final TextComponentCodec V1_21_5 = new TextComponentCodec(() -> SNbt.V1_21_5, () -> TextCodecs_v1_21_5.TEXT, () -> StyleCodecs_v1_21_5.CODEC, (DataConverter<JsonElement>)JsonConverter_v1_20_5.INSTANCE, (DataConverter<NbtTag>)NbtConverter_v1_21_5.INSTANCE);
    public static final TextComponentCodec V1_21_6 = new TextComponentCodec(() -> SNbt.V1_21_5, () -> TextCodecs_v1_21_6.TEXT, () -> StyleCodecs_v1_21_6.CODEC, (DataConverter<JsonElement>)JsonConverter_v1_20_5.INSTANCE, (DataConverter<NbtTag>)NbtConverter_v1_21_5.INSTANCE);
    public static final TextComponentCodec V1_21_9;
    public static final TextComponentCodec LATEST;
    private final Supplier<SNbt<CompoundTag>> sNbtSupplier;
    private final Supplier<Codec<TextComponent>> textCodecSupplier;
    private final Supplier<Codec<Style>> styleCodecSupplier;
    private final DataConverter<JsonElement> jsonConverter;
    private final DataConverter<NbtTag> nbtConverter;
    private SNbt<CompoundTag> sNbt;
    private Codec<TextComponent> textCodec;
    private Codec<Style> styleCodec;

    public TextComponentCodec(Supplier<SNbt<CompoundTag>> sNbtSupplier, Supplier<Codec<TextComponent>> textCodec, Supplier<Codec<Style>> styleCodec, DataConverter<JsonElement> jsonConverter, DataConverter<NbtTag> nbtConverter) {
        this.sNbtSupplier = sNbtSupplier;
        this.textCodecSupplier = textCodec;
        this.styleCodecSupplier = styleCodec;
        this.jsonConverter = jsonConverter;
        this.nbtConverter = nbtConverter;
    }

    private SNbt<CompoundTag> getSNbtSerializer() {
        if (this.sNbt == null) {
            this.sNbt = this.sNbtSupplier.get();
        }
        return this.sNbtSupplier.get();
    }

    public Codec<TextComponent> getTextCodec() {
        if (this.textCodec == null) {
            this.textCodec = this.textCodecSupplier.get();
        }
        return this.textCodec;
    }

    public Codec<Style> getStyleCodec() {
        if (this.styleCodec == null) {
            this.styleCodec = this.styleCodecSupplier.get();
        }
        return this.styleCodec;
    }

    public DataConverter<JsonElement> getJsonConverter() {
        return this.jsonConverter;
    }

    public DataConverter<NbtTag> getNbtConverter() {
        return this.nbtConverter;
    }

    public TextComponentCodec withVerifier(TextVerifier verifier) {
        return new TextComponentCodec(this.sNbtSupplier, this.textCodecSupplier, this.styleCodecSupplier, (DataConverter<JsonElement>)new VerifyingConverter<JsonElement>(this.jsonConverter, verifier), (DataConverter<NbtTag>)new VerifyingConverter<NbtTag>(this.nbtConverter, verifier));
    }

    public TextComponent deserializeJson(String json) {
        return this.deserializeJsonTree(JsonParser.parseString((String)json));
    }

    public TextComponent deserializeJsonReader(String json) {
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        reader.setLenient(false);
        try {
            return this.deserialize(Streams.parse((JsonReader)reader));
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", (Throwable)e);
        }
    }

    public TextComponent deserializeLenientJson(String json) {
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        reader.setLenient(true);
        return this.deserializeJsonTree(JsonParser.parseReader((JsonReader)reader));
    }

    public TextComponent deserializeNbt(String nbt) {
        try {
            return this.deserialize(this.getSNbtSerializer().getDeserializer().deserializeValue(nbt));
        }
        catch (SNbtDeserializeException e) {
            throw new RuntimeException("Failed to deserialize SNbt", e);
        }
    }

    public TextComponent deserializeJsonTree(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        return this.deserialize(element);
    }

    public TextComponent deserializeNbtTree(@Nullable NbtTag nbt) {
        if (nbt == null) {
            return null;
        }
        return this.deserialize(nbt);
    }

    public TextComponent deserialize(JsonElement json) {
        return (TextComponent)this.getTextCodec().deserialize(this.jsonConverter, (Object)json).getOrThrow(JsonParseException::new);
    }

    public TextComponent deserialize(NbtTag nbt) {
        return (TextComponent)this.getTextCodec().deserialize(this.nbtConverter, (Object)nbt).get();
    }

    public JsonElement serializeJsonTree(TextComponent component) {
        return (JsonElement)this.getTextCodec().serialize(this.jsonConverter, (Object)component).getOrThrow(JsonParseException::new);
    }

    public NbtTag serializeNbtTree(TextComponent component) {
        return (NbtTag)this.getTextCodec().serialize(this.nbtConverter, (Object)component).get();
    }

    public String serializeJsonString(TextComponent component) {
        return GSON.toJson(this.serializeJsonTree(component));
    }

    public String serializeNbtString(TextComponent component) {
        try {
            return this.getSNbtSerializer().serialize(this.serializeNbtTree(component));
        }
        catch (SNbtSerializeException e) {
            throw new RuntimeException("Failed to serialize SNbt", e);
        }
    }

    public TextComponentSerializer asSerializer() {
        return new TextComponentSerializer(this, () -> new GsonBuilder().registerTypeHierarchyAdapter(TextComponent.class, (src, typeOfSrc, context) -> this.serializeJsonTree((TextComponent)src)).registerTypeHierarchyAdapter(TextComponent.class, (src, typeOfSrc, context) -> this.deserializeJsonTree(src)).disableHtmlEscaping().create());
    }

    static {
        LATEST = V1_21_9 = new TextComponentCodec(() -> SNbt.V1_21_5, () -> TextCodecs_v1_21_9.TEXT, () -> StyleCodecs_v1_21_9.CODEC, (DataConverter<JsonElement>)JsonConverter_v1_20_5.INSTANCE, (DataConverter<NbtTag>)NbtConverter_v1_21_5.INSTANCE);
    }
}

