/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer.v1_16;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.lenni0451.mcstructs.text.Style;
import net.lenni0451.mcstructs.text.events.click.ClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.ChangePageClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.CopyToClipboardClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.OpenFileClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.OpenUrlClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.RunCommandClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.SuggestCommandClickEvent;
import net.lenni0451.mcstructs.text.font.ResourceFont;

public class StyleSerializer_v1_16
implements JsonSerializer<Style> {
    public JsonElement serialize(Style src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.isEmpty()) {
            return null;
        }
        JsonObject serializedStyle = new JsonObject();
        if (src.getBold() != null) {
            serializedStyle.addProperty("bold", Boolean.valueOf(src.isBold()));
        }
        if (src.getItalic() != null) {
            serializedStyle.addProperty("italic", Boolean.valueOf(src.isItalic()));
        }
        if (src.getUnderlined() != null) {
            serializedStyle.addProperty("underlined", Boolean.valueOf(src.isUnderlined()));
        }
        if (src.getStrikethrough() != null) {
            serializedStyle.addProperty("strikethrough", Boolean.valueOf(src.isStrikethrough()));
        }
        if (src.getObfuscated() != null) {
            serializedStyle.addProperty("obfuscated", Boolean.valueOf(src.isObfuscated()));
        }
        if (src.getColor() != null) {
            serializedStyle.addProperty("color", src.getColor().serialize());
        }
        if (src.getInsertion() != null) {
            serializedStyle.add("insertion", context.serialize((Object)src.getInsertion()));
        }
        if (src.getClickEvent() != null) {
            JsonObject clickEvent = new JsonObject();
            clickEvent.addProperty("action", src.getClickEvent().getAction().getName());
            clickEvent.addProperty("value", this.serializeClickEvent(src.getClickEvent()));
            serializedStyle.add("clickEvent", (JsonElement)clickEvent);
        }
        if (src.getHoverEvent() != null) {
            serializedStyle.add("hoverEvent", context.serialize((Object)src.getHoverEvent()));
        }
        if (src.getFont() != null) {
            if (src.getFont() instanceof ResourceFont) {
                serializedStyle.addProperty("font", ((ResourceFont)src.getFont()).getId().get());
            } else {
                throw new IllegalStateException("Unsupported font type: " + src.getFont().getClass().getName());
            }
        }
        return serializedStyle;
    }

    private String serializeClickEvent(ClickEvent clickEvent) {
        if (clickEvent instanceof OpenUrlClickEvent) {
            return ((OpenUrlClickEvent)clickEvent).asString();
        }
        if (clickEvent instanceof OpenFileClickEvent) {
            return ((OpenFileClickEvent)clickEvent).getPath();
        }
        if (clickEvent instanceof RunCommandClickEvent) {
            return ((RunCommandClickEvent)clickEvent).getCommand();
        }
        if (clickEvent instanceof SuggestCommandClickEvent) {
            return ((SuggestCommandClickEvent)clickEvent).getCommand();
        }
        if (clickEvent instanceof ChangePageClickEvent) {
            return ((ChangePageClickEvent)clickEvent).asString();
        }
        if (clickEvent instanceof CopyToClipboardClickEvent) {
            return ((CopyToClipboardClickEvent)clickEvent).getValue();
        }
        throw new IllegalArgumentException("Unknown click event type: " + clickEvent.getClass().getName());
    }
}

