/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer.v1_21_5;

import net.lenni0451.mcstructs.converter.codec.Codec;
import net.lenni0451.mcstructs.converter.codec.map.MapCodecMerger;
import net.lenni0451.mcstructs.converter.impl.v1_20_3.NbtConverter_v1_20_3;
import net.lenni0451.mcstructs.converter.mapcodec.MapCodec;
import net.lenni0451.mcstructs.converter.model.Result;
import net.lenni0451.mcstructs.converter.types.NamedType;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.text.Style;
import net.lenni0451.mcstructs.text.TextFormatting;
import net.lenni0451.mcstructs.text.events.click.ClickEvent;
import net.lenni0451.mcstructs.text.events.click.ClickEventAction;
import net.lenni0451.mcstructs.text.events.click.types.ChangePageClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.CopyToClipboardClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.OpenFileClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.OpenUrlClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.RunCommandClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.SuggestCommandClickEvent;
import net.lenni0451.mcstructs.text.events.hover.HoverEvent;
import net.lenni0451.mcstructs.text.events.hover.HoverEventAction;
import net.lenni0451.mcstructs.text.events.hover.impl.EntityHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.impl.ItemHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.impl.TextHoverEvent;
import net.lenni0451.mcstructs.text.font.ResourceFont;
import net.lenni0451.mcstructs.text.serializer.v1_21_5.ExtraCodecs_v1_21_5;
import net.lenni0451.mcstructs.text.serializer.v1_21_5.TextCodecs_v1_21_5;
import net.lenni0451.mcstructs.text.serializer.v1_21_5.TextVerifier_v1_21_5;
import net.lenni0451.mcstructs.text.serializer.verify.VerifyingConverter;

public class StyleCodecs_v1_21_5 {
    public static final MapCodec<Style> MAP_CODEC = MapCodecMerger.mapCodec((MapCodec)TextFormattingCodec.CODEC.mapCodec("color").optional().defaulted(null), Style::getColor, (MapCodec)ExtraCodecs_v1_21_5.ARGB_COLOR.mapCodec("shadow_color").optional().defaulted(null), Style::getShadowColor, (MapCodec)Codec.BOOLEAN.mapCodec("obfuscated").optional().defaulted(null), Style::getObfuscated, (MapCodec)Codec.BOOLEAN.mapCodec("bold").optional().defaulted(null), Style::getBold, (MapCodec)Codec.BOOLEAN.mapCodec("strikethrough").optional().defaulted(null), Style::getStrikethrough, (MapCodec)Codec.BOOLEAN.mapCodec("underlined").optional().defaulted(null), Style::getUnderlined, (MapCodec)Codec.BOOLEAN.mapCodec("italic").optional().defaulted(null), Style::getItalic, (MapCodec)ClickEventCodec.CODEC.mapCodec("click_event").optional().defaulted(null), Style::getClickEvent, (MapCodec)HoverEventCodec.CODEC.mapCodec("hover_event").optional().defaulted(null), Style::getHoverEvent, (MapCodec)Codec.STRING.mapCodec("insertion").optional().defaulted(null), Style::getInsertion, (MapCodec)Codec.STRING_IDENTIFIER.mapCodec("font").optional().defaulted(null).mapThrowing(fontDescription -> {
        if (fontDescription == null) {
            return null;
        }
        return ((ResourceFont)fontDescription).getId();
    }, id -> {
        if (id == null) {
            return null;
        }
        return new ResourceFont((Identifier)id);
    }), Style::getFont, Style::new);
    public static final Codec<Style> CODEC = MAP_CODEC.asCodec();

    public static class HoverEventCodec {
        public static final MapCodec<TextHoverEvent> TEXT = MapCodecMerger.mapCodec((MapCodec)TextCodecs_v1_21_5.TEXT.mapCodec("value").required(), TextHoverEvent::getText, TextHoverEvent::new);
        public static final MapCodec<ItemHoverEvent> ITEM = MapCodecMerger.mapCodec((MapCodec)Codec.STRING_IDENTIFIER.converterVerified(VerifyingConverter.verify(TextVerifier_v1_21_5.class, TextVerifier_v1_21_5::verifyRegistryItem, "Invalid item")).mapCodec("id").required(), hoverEvent -> hoverEvent.asModern().getId(), (MapCodec)Codec.rangedInt((int)1, (int)99).mapCodec("count").optional().elseGet(() -> 1), hoverEvent -> hoverEvent.asModern().getCount(), (MapCodec)NbtConverter_v1_20_3.INSTANCE.toCodec().verified(tag -> {
            if (!tag.isCompoundTag()) {
                return Result.error((String)"Expected a compound tag");
            }
            return null;
        }).map(NbtTag::asCompoundTag, NbtTag::asCompoundTag).converterVerified(VerifyingConverter.verify(TextVerifier_v1_21_5.class, TextVerifier_v1_21_5::verifyDataComponents, "Invalid data components")).mapCodec("components").optional().defaulted(null), hoverEvent -> hoverEvent.asModern().getTag(), ItemHoverEvent::new);
        public static final MapCodec<EntityHoverEvent> ENTITY = MapCodecMerger.mapCodec((MapCodec)Codec.STRING_IDENTIFIER.converterVerified(VerifyingConverter.verify(TextVerifier_v1_21_5.class, TextVerifier_v1_21_5::verifyRegistryEntity, "Invalid entity")).mapCodec("id").required(), hoverEvent -> hoverEvent.asModern().getType(), (MapCodec)ExtraCodecs_v1_21_5.LENIENT_UUID.mapCodec("uuid").required(), hoverEvent -> hoverEvent.asModern().getUuid(), (MapCodec)TextCodecs_v1_21_5.TEXT.mapCodec("name").optional().defaulted(null), hoverEvent -> hoverEvent.asModern().getName(), EntityHoverEvent::new);
        public static final Codec<HoverEvent> CODEC = Codec.named((NamedType[])new HoverEventAction[]{HoverEventAction.SHOW_TEXT, HoverEventAction.SHOW_ITEM, HoverEventAction.SHOW_ENTITY}).verified(action -> {
            if (action.isUserDefinable()) {
                return null;
            }
            return Result.error((String)("The action " + action.getName() + " is not user definable"));
        }).typed("action", HoverEvent::getAction, action -> {
            switch (action) {
                case SHOW_TEXT: {
                    return TEXT;
                }
                case SHOW_ITEM: {
                    return ITEM;
                }
                case SHOW_ENTITY: {
                    return ENTITY;
                }
            }
            return MapCodec.failing((String)("Unknown hover event action: " + (Object)action));
        });
    }

    public static class ClickEventCodec {
        public static final MapCodec<OpenUrlClickEvent> OPEN_URL = MapCodecMerger.mapCodec((MapCodec)ExtraCodecs_v1_21_5.UNTRUSTED_URI.mapCodec("url").required(), OpenUrlClickEvent::asUri, ClickEvent::openUrl);
        public static final MapCodec<OpenFileClickEvent> OPEN_FILE = MapCodecMerger.mapCodec((MapCodec)Codec.STRING.mapCodec("path").required(), OpenFileClickEvent::getPath, ClickEvent::openFile);
        public static final MapCodec<RunCommandClickEvent> RUN_COMMAND = MapCodecMerger.mapCodec((MapCodec)ExtraCodecs_v1_21_5.CHAT_STRING.mapCodec("command").required(), RunCommandClickEvent::getCommand, ClickEvent::runCommand);
        public static final MapCodec<SuggestCommandClickEvent> SUGGEST_COMMAND = MapCodecMerger.mapCodec((MapCodec)ExtraCodecs_v1_21_5.CHAT_STRING.mapCodec("command").required(), SuggestCommandClickEvent::getCommand, ClickEvent::suggestCommand);
        public static final MapCodec<ChangePageClickEvent> CHANGE_PAGE = MapCodecMerger.mapCodec((MapCodec)Codec.minInt((int)1).mapCodec("page").required(), ChangePageClickEvent::asInt, ClickEvent::changePage);
        public static final MapCodec<CopyToClipboardClickEvent> COPY_TO_CLIPBOARD = MapCodecMerger.mapCodec((MapCodec)Codec.STRING.mapCodec("value").required(), CopyToClipboardClickEvent::getValue, ClickEvent::copyToClipboard);
        public static final Codec<ClickEvent> CODEC = Codec.named((NamedType[])new ClickEventAction[]{ClickEventAction.OPEN_URL, ClickEventAction.OPEN_FILE, ClickEventAction.RUN_COMMAND, ClickEventAction.SUGGEST_COMMAND, ClickEventAction.CHANGE_PAGE, ClickEventAction.COPY_TO_CLIPBOARD}).verified(type -> {
            if (type.isUserDefinable()) {
                return null;
            }
            return Result.error((String)("The action " + type.getName() + " is not user definable"));
        }).typed("action", ClickEvent::getAction, action -> {
            switch (action) {
                case OPEN_URL: {
                    return OPEN_URL;
                }
                case OPEN_FILE: {
                    return OPEN_FILE;
                }
                case RUN_COMMAND: {
                    return RUN_COMMAND;
                }
                case SUGGEST_COMMAND: {
                    return SUGGEST_COMMAND;
                }
                case CHANGE_PAGE: {
                    return CHANGE_PAGE;
                }
                case COPY_TO_CLIPBOARD: {
                    return COPY_TO_CLIPBOARD;
                }
            }
            return MapCodec.failing((String)("Unknown click event action: " + (Object)action));
        });
    }

    public static class TextFormattingCodec {
        public static final Codec<TextFormatting> CODEC = Codec.STRING.flatMap(formatting -> Result.success((Object)formatting.serialize()), s -> {
            TextFormatting formatting = TextFormatting.parse(s);
            if (formatting == null) {
                return Result.error((String)("Unknown formatting: " + s));
            }
            if (formatting.isRGBColor() && (formatting.getRgbValue() < 0 || formatting.getRgbValue() > 0xFFFFFF)) {
                return Result.error((String)("Out of range RGB value: " + s));
            }
            return Result.success((Object)formatting);
        });
    }
}

