/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

public class JsonNbtConverter {
    @Nullable
    public static JsonElement toJson(@Nullable NbtTag tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.getNbtType()) {
            case END: {
                return null;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new JsonPrimitive(tag.asNumberTag().numberValue());
            }
            case BYTE_ARRAY: {
                JsonArray byteArray = new JsonArray();
                for (byte b : tag.asByteArrayTag().getValue()) {
                    byteArray.add((Number)b);
                }
                return byteArray;
            }
            case STRING: {
                return new JsonPrimitive(tag.asStringTag().getValue());
            }
            case LIST: {
                JsonArray list = new JsonArray();
                ListTag listTag = tag.asListTag();
                for (NbtTag tagInList : listTag.getValue()) {
                    NbtTag wrappedTag;
                    CompoundTag compound;
                    if (NbtType.COMPOUND.equals((Object)listTag.getType()) && (compound = tagInList.asCompoundTag()).size() == 1 && (wrappedTag = compound.get("")) != null) {
                        tagInList = wrappedTag;
                    }
                    list.add(JsonNbtConverter.toJson(tagInList));
                }
                return list;
            }
            case COMPOUND: {
                JsonObject compound = new JsonObject();
                for (Map.Entry entry : tag.asCompoundTag().getValue().entrySet()) {
                    compound.add((String)entry.getKey(), JsonNbtConverter.toJson((NbtTag)entry.getValue()));
                }
                return compound;
            }
            case INT_ARRAY: {
                JsonArray intArray = new JsonArray();
                for (int i : tag.asIntArrayTag().getValue()) {
                    intArray.add((Number)i);
                }
                return intArray;
            }
            case LONG_ARRAY: {
                JsonArray longArray = new JsonArray();
                for (long l : tag.asLongArrayTag().getValue()) {
                    longArray.add((Number)l);
                }
                return longArray;
            }
        }
        throw new IllegalArgumentException("Unknown Nbt type: " + tag.getNbtType());
    }

    @Nullable
    public static NbtTag toNbt(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof JsonObject) {
            JsonObject object = element.getAsJsonObject();
            CompoundTag compound = new CompoundTag();
            for (Map.Entry entry : object.entrySet()) {
                compound.add((String)entry.getKey(), JsonNbtConverter.toNbt((JsonElement)entry.getValue()));
            }
            return compound;
        }
        if (element instanceof JsonArray) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<NbtTag> nbtTags = new ArrayList<NbtTag>();
            NbtType listType = null;
            for (Object arrayElement : array) {
                NbtTag tag = JsonNbtConverter.toNbt((JsonElement)arrayElement);
                nbtTags.add(tag);
                listType = JsonNbtConverter.getListType(listType, tag);
            }
            if (listType == null) {
                return new ListTag();
            }
            if (listType == NbtType.END) {
                ListTag list = new ListTag();
                for (NbtTag tag : nbtTags) {
                    if (tag instanceof CompoundTag) {
                        list.add((NbtTag)tag.asCompoundTag());
                        continue;
                    }
                    list.add((NbtTag)new CompoundTag().add("", tag));
                }
                return list;
            }
            if (listType == NbtType.BYTE) {
                byte[] bytes = new byte[nbtTags.size()];
                for (int i = 0; i < nbtTags.size(); ++i) {
                    bytes[i] = ((NbtTag)nbtTags.get(i)).asByteTag().byteValue();
                }
                return new ByteArrayTag(bytes);
            }
            if (listType == NbtType.INT) {
                int[] ints = new int[nbtTags.size()];
                for (int i = 0; i < nbtTags.size(); ++i) {
                    ints[i] = ((NbtTag)nbtTags.get(i)).asIntTag().intValue();
                }
                return new IntArrayTag(ints);
            }
            if (listType == NbtType.LONG) {
                long[] longs = new long[nbtTags.size()];
                for (int i = 0; i < nbtTags.size(); ++i) {
                    longs[i] = ((NbtTag)nbtTags.get(i)).asIntTag().intValue();
                }
                return new LongArrayTag(longs);
            }
            return new ListTag(nbtTags);
        }
        if (element instanceof JsonNull) {
            return null;
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return new StringTag(primitive.getAsString());
            }
            if (primitive.isBoolean()) {
                return new ByteTag(primitive.getAsBoolean());
            }
            BigDecimal number = primitive.getAsBigDecimal();
            try {
                long l = number.longValueExact();
                if ((long)((byte)l) == l) {
                    return new ByteTag((byte)l);
                }
                if ((long)((short)l) == l) {
                    return new ShortTag((short)l);
                }
                if ((long)((int)l) == l) {
                    return new IntTag((int)l);
                }
                return new LongTag(l);
            }
            catch (ArithmeticException e) {
                double d = number.doubleValue();
                if ((double)((float)d) == d) {
                    return new FloatTag((float)d);
                }
                return new DoubleTag(d);
            }
        }
        throw new IllegalArgumentException("Unknown JsonElement type: " + element.getClass().getName());
    }

    private static NbtType getListType(NbtType current, NbtTag tag) {
        if (current == null) {
            return tag.getNbtType();
        }
        if (current != tag.getNbtType()) {
            return NbtType.END;
        }
        return current;
    }
}

