/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.lenni0451.mcstructs.core.Copyable;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.text.Style;
import net.lenni0451.mcstructs.text.TextFormatting;
import net.lenni0451.mcstructs.text.components.KeybindComponent;
import net.lenni0451.mcstructs.text.components.NbtComponent;
import net.lenni0451.mcstructs.text.components.ObjectComponent;
import net.lenni0451.mcstructs.text.components.ScoreComponent;
import net.lenni0451.mcstructs.text.components.SelectorComponent;
import net.lenni0451.mcstructs.text.components.StringComponent;
import net.lenni0451.mcstructs.text.components.TranslationComponent;
import net.lenni0451.mcstructs.text.components.nbt.BlockNbtSource;
import net.lenni0451.mcstructs.text.components.nbt.EntityNbtSource;
import net.lenni0451.mcstructs.text.components.nbt.StorageNbtSource;
import net.lenni0451.mcstructs.text.stringformat.StringFormat;
import net.lenni0451.mcstructs.text.stringformat.handling.ColorHandling;
import net.lenni0451.mcstructs.text.stringformat.handling.SerializerUnknownHandling;

public abstract class TextComponent
implements Copyable<TextComponent> {
    private static final StringFormat LEGACY_FORMAT = StringFormat.vanilla('\u00a7', false);
    private List<TextComponent> siblings;
    private Style style;

    public TextComponent append(String ... strings) {
        for (String s : strings) {
            this.getSiblings().add(new StringComponent(s));
        }
        return this;
    }

    public TextComponent append(TextComponent component) {
        this.getSiblings().add(component);
        return this;
    }

    public TextComponent append(TextComponent ... components) {
        Collections.addAll(this.getSiblings(), components);
        return this;
    }

    public TextComponent append(Iterable<TextComponent> components) {
        components.forEach(this.getSiblings()::add);
        return this;
    }

    public List<TextComponent> getSiblings() {
        if (this.siblings == null) {
            this.siblings = new ArrayList<TextComponent>();
        }
        return this.siblings;
    }

    public TextComponent forEach(Consumer<TextComponent> consumer) {
        consumer.accept(this);
        if (this.siblings != null) {
            for (TextComponent sibling : this.siblings) {
                sibling.forEach(consumer);
            }
        }
        return this;
    }

    @Nonnull
    public Style getStyle() {
        if (this.style == null) {
            this.style = new Style();
        }
        return this.style;
    }

    public TextComponent setStyle(@Nonnull Style style) {
        this.style = style;
        return this;
    }

    public TextComponent styled(Consumer<Style> styleConsumer) {
        styleConsumer.accept(this.getStyle());
        return this;
    }

    public TextComponent formatted(TextFormatting formatting) {
        this.getStyle().setFormatting(formatting);
        return this;
    }

    public TextComponent setParentStyle(@Nonnull Style style) {
        this.getStyle().setParent(style);
        return this;
    }

    public TextComponent setSiblingParentStyle() {
        if (this.siblings == null) {
            return this;
        }
        for (TextComponent sibling : this.siblings) {
            sibling.getStyle().setParent(this.getStyle());
            sibling.setSiblingParentStyle();
        }
        return this;
    }

    public TextComponent mergeSiblingParentStyle() {
        if (this.siblings == null) {
            return this;
        }
        for (TextComponent sibling : this.siblings) {
            sibling.getStyle().setParent(this.getStyle());
            sibling.getStyle().mergeParent();
            sibling.mergeSiblingParentStyle();
        }
        return this;
    }

    public <C extends TextComponent> C copyMetaTo(C component) {
        component.setStyle(this.getStyle().copy());
        if (this.siblings != null) {
            for (TextComponent sibling : this.siblings) {
                component.append(sibling.copy());
            }
        }
        return component;
    }

    public String asUnformattedString() {
        StringBuilder out = new StringBuilder(this.asSingleString());
        if (this.siblings != null) {
            for (TextComponent sibling : this.siblings) {
                out.append(sibling.asUnformattedString());
            }
        }
        return out.toString();
    }

    public String asLegacyFormatString() {
        return LEGACY_FORMAT.toString(this, ColorHandling.RESET, SerializerUnknownHandling.IGNORE);
    }

    public abstract String asSingleString();

    public abstract TextComponent copy();

    public TextComponent shallowCopy() {
        TextComponent copy = this.copy();
        copy.getSiblings().clear();
        return copy;
    }

    public abstract String toString();

    public static StringComponent empty() {
        return new StringComponent();
    }

    public static StringComponent of(String text) {
        return new StringComponent(text);
    }

    public static TextComponent of(String ... text) {
        if (text.length == 0) {
            return new StringComponent();
        }
        if (text.length == 1) {
            return new StringComponent(text[0]);
        }
        StringComponent component = new StringComponent();
        component.append(text);
        return component;
    }

    public static TextComponent of(TextComponent ... components) {
        if (components.length == 0) {
            return new StringComponent();
        }
        if (components.length == 1) {
            return components[0];
        }
        StringComponent component = new StringComponent();
        component.append(components);
        return component;
    }

    public static TextComponent of(Iterable<TextComponent> components) {
        StringComponent component = new StringComponent();
        components.forEach(component::append);
        return component;
    }

    public static TranslationComponent translation(String key, List<Object> args) {
        return new TranslationComponent(key, args);
    }

    public static TranslationComponent translation(String key, Object ... args) {
        return new TranslationComponent(key, args);
    }

    public static ScoreComponent score(String name, String objective) {
        return new ScoreComponent(name, objective);
    }

    public static ScoreComponent score(String name, String objective, @Nullable String value) {
        return new ScoreComponent(name, objective, value);
    }

    public static SelectorComponent selector(String selector) {
        return new SelectorComponent(selector);
    }

    public static SelectorComponent selector(String selector, @Nullable TextComponent separator) {
        return new SelectorComponent(selector, separator);
    }

    public static KeybindComponent keybind(String keybind) {
        return new KeybindComponent(keybind);
    }

    public static NbtComponent blockNbt(String rawComponent, boolean resolve, String pos) {
        return new NbtComponent(rawComponent, resolve, new BlockNbtSource(pos));
    }

    public static NbtComponent blockNbt(String rawComponent, boolean resolve, @Nullable TextComponent separator, String pos) {
        return new NbtComponent(rawComponent, resolve, separator, new BlockNbtSource(pos));
    }

    public static NbtComponent entityNbt(String component, boolean resolve, String selector) {
        return new NbtComponent(component, resolve, new EntityNbtSource(selector));
    }

    public static NbtComponent entityNbt(String component, boolean resolve, @Nullable TextComponent separator, String selector) {
        return new NbtComponent(component, resolve, separator, new EntityNbtSource(selector));
    }

    public static NbtComponent storageNbt(String component, boolean resolve, Identifier id) {
        return new NbtComponent(component, resolve, new StorageNbtSource(id));
    }

    public static NbtComponent storageNbt(String component, boolean resolve, @Nullable TextComponent separator, Identifier id) {
        return new NbtComponent(component, resolve, separator, new StorageNbtSource(id));
    }

    public static ObjectComponent atlasSprite(Identifier sprite) {
        return new ObjectComponent(new ObjectComponent.AtlasSprite(sprite));
    }

    public static ObjectComponent atlasSprite(Identifier atlas, Identifier sprite) {
        return new ObjectComponent(new ObjectComponent.AtlasSprite(atlas, sprite));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextComponent)) {
            return false;
        }
        TextComponent other = (TextComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TextComponent> this$siblings = this.getSiblings();
        List<TextComponent> other$siblings = other.getSiblings();
        if (this$siblings == null ? other$siblings != null : !((Object)this$siblings).equals(other$siblings)) {
            return false;
        }
        Style this$style = this.getStyle();
        Style other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TextComponent> $siblings = this.getSiblings();
        result = result * 59 + ($siblings == null ? 43 : ((Object)$siblings).hashCode());
        Style $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }
}

