/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer.v1_21_4;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.lenni0451.mcstructs.converter.DataConverter;
import net.lenni0451.mcstructs.converter.codec.Codec;
import net.lenni0451.mcstructs.converter.codec.map.MapCodecMerger;
import net.lenni0451.mcstructs.converter.impl.v1_20_3.NbtConverter_v1_20_3;
import net.lenni0451.mcstructs.converter.impl.v1_20_5.JsonConverter_v1_20_5;
import net.lenni0451.mcstructs.converter.mapcodec.MapCodec;
import net.lenni0451.mcstructs.converter.model.Result;
import net.lenni0451.mcstructs.converter.types.NamedType;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.snbt.SNbt;
import net.lenni0451.mcstructs.text.Style;
import net.lenni0451.mcstructs.text.TextComponent;
import net.lenni0451.mcstructs.text.TextFormatting;
import net.lenni0451.mcstructs.text.events.click.ClickEvent;
import net.lenni0451.mcstructs.text.events.click.ClickEventAction;
import net.lenni0451.mcstructs.text.events.click.types.ChangePageClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.CopyToClipboardClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.OpenFileClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.OpenUrlClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.RunCommandClickEvent;
import net.lenni0451.mcstructs.text.events.click.types.SuggestCommandClickEvent;
import net.lenni0451.mcstructs.text.events.hover.HoverEvent;
import net.lenni0451.mcstructs.text.events.hover.HoverEventAction;
import net.lenni0451.mcstructs.text.events.hover.impl.EntityHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.impl.ItemHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.impl.TextHoverEvent;
import net.lenni0451.mcstructs.text.font.ResourceFont;
import net.lenni0451.mcstructs.text.serializer.v1_21_4.ExtraCodecs_v1_21_4;
import net.lenni0451.mcstructs.text.serializer.v1_21_4.TextCodecs_v1_21_4;
import net.lenni0451.mcstructs.text.serializer.v1_21_4.TextVerifier_v1_21_4;
import net.lenni0451.mcstructs.text.serializer.verify.VerifyingConverter;

public class StyleCodecs_v1_21_4 {
    public static final MapCodec<Style> MAP_CODEC = MapCodecMerger.mapCodec((MapCodec)TextFormattingCodec.CODEC.mapCodec("color").optional().defaulted(null), Style::getColor, (MapCodec)ExtraCodecs_v1_21_4.ARGB_COLOR.mapCodec("shadow_color").optional().defaulted(null), Style::getShadowColor, (MapCodec)Codec.BOOLEAN.mapCodec("obfuscated").optional().defaulted(null), Style::getObfuscated, (MapCodec)Codec.BOOLEAN.mapCodec("bold").optional().defaulted(null), Style::getBold, (MapCodec)Codec.BOOLEAN.mapCodec("strikethrough").optional().defaulted(null), Style::getStrikethrough, (MapCodec)Codec.BOOLEAN.mapCodec("underlined").optional().defaulted(null), Style::getUnderlined, (MapCodec)Codec.BOOLEAN.mapCodec("italic").optional().defaulted(null), Style::getItalic, (MapCodec)ClickEventCodec.CODEC.mapCodec("clickEvent").optional().defaulted(null), Style::getClickEvent, (MapCodec)HoverEventCodec.CODEC.mapCodec("hoverEvent").optional().defaulted(null), Style::getHoverEvent, (MapCodec)Codec.STRING.mapCodec("insertion").optional().defaulted(null), Style::getInsertion, (MapCodec)Codec.STRING_IDENTIFIER.mapCodec("font").optional().defaulted(null).mapThrowing(fontDescription -> {
        if (fontDescription == null) {
            return null;
        }
        return ((ResourceFont)fontDescription).getId();
    }, id -> {
        if (id == null) {
            return null;
        }
        return new ResourceFont((Identifier)id);
    }), Style::getFont, Style::new);
    public static final Codec<Style> CODEC = MAP_CODEC.asCodec();

    public static class HoverEventCodec {
        private static final String CONTENTS = "contents";
        public static final Codec<HoverEvent> MODERN_CODEC = Codec.named((NamedType[])new HoverEventAction[]{HoverEventAction.SHOW_TEXT, HoverEventAction.SHOW_ITEM, HoverEventAction.SHOW_ENTITY}).verified(action -> {
            if (action.isUserDefinable()) {
                return null;
            }
            return Result.error((String)("The action " + action.getName() + " is not user definable"));
        }).typed("action", HoverEvent::getAction, action -> {
            switch (action) {
                case SHOW_TEXT: {
                    return Text.MAP_CODEC;
                }
                case SHOW_ITEM: {
                    return Item.MAP_CODEC;
                }
                case SHOW_ENTITY: {
                    return Entity.MAP_CODEC;
                }
            }
            return MapCodec.failing((String)("Unknown hover event action: " + (Object)action));
        });
        public static final Codec<HoverEvent> LEGACY_CODEC = Codec.named((NamedType[])new HoverEventAction[]{HoverEventAction.SHOW_TEXT, HoverEventAction.SHOW_ITEM, HoverEventAction.SHOW_ENTITY}).verified(action -> {
            if (action.isUserDefinable()) {
                return null;
            }
            return Result.error((String)("The action " + action.getName() + " is not user definable"));
        }).typed("action", HoverEvent::getAction, action -> {
            switch (action) {
                case SHOW_TEXT: {
                    return Text.LEGACY_MAP_CODEC;
                }
                case SHOW_ITEM: {
                    return Item.LEGACY_MAP_CODEC;
                }
                case SHOW_ENTITY: {
                    return Entity.LEGACY_MAP_CODEC;
                }
            }
            return MapCodec.failing((String)("Unknown hover event action: " + (Object)action));
        });
        public static final Codec<HoverEvent> CODEC = Codec.oneOf((Codec[])new Codec[]{MODERN_CODEC, LEGACY_CODEC});

        private static <T extends HoverEvent> MapCodec<T> createLegacy(BiFunction<DataConverter<?>, TextComponent, Result<T>> constructor) {
            return TextCodecs_v1_21_4.TEXT.converterFlatMap((dataConverter, t) -> Result.error((String)"Legacy hover events can't be serialized"), constructor).mapCodec("value").required();
        }

        static /* synthetic */ MapCodec access$000(BiFunction x0) {
            return HoverEventCodec.createLegacy(x0);
        }

        public static class Entity {
            public static final MapCodec<EntityHoverEvent> MAP_CODEC = MapCodecMerger.codec((MapCodec)Codec.STRING_IDENTIFIER.converterVerified(VerifyingConverter.verify(TextVerifier_v1_21_4.class, TextVerifier_v1_21_4::verifyRegistryEntity, "Invalid entity")).mapCodec("type").required(), EntityHoverEvent.ModernHolder::getType, (MapCodec)ExtraCodecs_v1_21_4.LENIENT_UUID.mapCodec("id").required(), EntityHoverEvent.ModernHolder::getUuid, (MapCodec)TextCodecs_v1_21_4.TEXT.mapCodec("name").optional().defaulted(null), EntityHoverEvent.ModernHolder::getName, EntityHoverEvent.ModernHolder::new).mapCodec("contents").required().map(EntityHoverEvent::asModern, EntityHoverEvent::new);
            public static final MapCodec<EntityHoverEvent> LEGACY_MAP_CODEC = HoverEventCodec.access$000((converter, component) -> {
                try {
                    CompoundTag tag = (CompoundTag)SNbt.V1_14.deserialize(component.asUnformattedString());
                    JsonElement rawName = JsonParser.parseString((String)tag.getString("name"));
                    TextComponent name = rawName == null ? null : (TextComponent)TextCodecs_v1_21_4.TEXT.deserialize(converter.fork((DataConverter)JsonConverter_v1_20_5.INSTANCE), (Object)rawName).getOrThrow(JsonParseException::new);
                    Identifier type = Identifier.of((String)tag.getString("type"));
                    if (!VerifyingConverter.isValid(converter, type, TextVerifier_v1_21_4.class, TextVerifier_v1_21_4::verifyRegistryEntity)) {
                        return Result.error((String)("Invalid entity: " + type));
                    }
                    UUID uuid = UUID.fromString(tag.getString("id"));
                    return Result.success((Object)new EntityHoverEvent(type, uuid, name));
                }
                catch (Throwable t) {
                    return Result.error((Throwable)t);
                }
            });
        }

        public static class Item {
            private static final Codec<Identifier> NON_AIR_ITEM = Codec.STRING_IDENTIFIER.converterVerified(VerifyingConverter.verify(TextVerifier_v1_21_4.class, TextVerifier_v1_21_4::verifyRegistryItem, "Invalid item")).verified(id -> {
                if (!id.equals("minecraft", "air")) {
                    return null;
                }
                return Result.error((String)"Item must not be minecraft:air");
            });
            private static final Codec<ItemHoverEvent.ModernHolder> ITEM_STACK_CODEC = MapCodecMerger.codec((MapCodec)NON_AIR_ITEM.mapCodec("id").required(), ItemHoverEvent.ModernHolder::getId, (MapCodec)Codec.minInt((int)1).mapCodec("count").optional().elseGet(() -> 1), ItemHoverEvent.ModernHolder::getCount, (MapCodec)ExtraCodecs_v1_21_4.INLINED_COMPOUND_TAG.converterVerified(VerifyingConverter.verify(TextVerifier_v1_21_4.class, TextVerifier_v1_21_4::verifyDataComponents, "Invalid data components")).mapCodec("components").optional().defaulted(null), ItemHoverEvent.ModernHolder::getTag, ItemHoverEvent.ModernHolder::new);
            private static final Codec<ItemHoverEvent.ModernHolder> SIMPLE_ITEM_CODEC = NON_AIR_ITEM.map(ItemHoverEvent.ModernHolder::getId, id -> new ItemHoverEvent.ModernHolder((Identifier)id, 1, null));
            public static final MapCodec<ItemHoverEvent> MAP_CODEC = Codec.oneOf((Codec[])new Codec[]{ITEM_STACK_CODEC, SIMPLE_ITEM_CODEC}).mapCodec("contents").required().map(ItemHoverEvent::asModern, ItemHoverEvent::new);
            public static final MapCodec<ItemHoverEvent> LEGACY_MAP_CODEC = HoverEventCodec.access$000((converter, component) -> {
                try {
                    CompoundTag tag = (CompoundTag)SNbt.V1_14.deserialize(component.asUnformattedString());
                    return ITEM_STACK_CODEC.deserialize(converter.fork((DataConverter)NbtConverter_v1_20_3.INSTANCE), (Object)tag).map(ItemHoverEvent::new);
                }
                catch (Throwable t) {
                    return Result.error((Throwable)t);
                }
            });
        }

        public static class Text {
            public static final MapCodec<TextHoverEvent> MAP_CODEC = TextCodecs_v1_21_4.TEXT.mapCodec("contents").required().map(TextHoverEvent::getText, TextHoverEvent::new);
            public static final MapCodec<TextHoverEvent> LEGACY_MAP_CODEC = HoverEventCodec.access$000((converter, component) -> Result.success((Object)new TextHoverEvent((TextComponent)component)));
        }
    }

    public static class ClickEventCodec {
        public static final MapCodec<OpenUrlClickEvent> OPEN_URL = ClickEventCodec.create(OpenUrlClickEvent::asString, OpenUrlClickEvent::new);
        public static final MapCodec<OpenFileClickEvent> OPEN_FILE = ClickEventCodec.create(OpenFileClickEvent::getPath, OpenFileClickEvent::new);
        public static final MapCodec<RunCommandClickEvent> RUN_COMMAND = ClickEventCodec.create(RunCommandClickEvent::getCommand, RunCommandClickEvent::new);
        public static final MapCodec<SuggestCommandClickEvent> SUGGEST_COMMAND = ClickEventCodec.create(SuggestCommandClickEvent::getCommand, SuggestCommandClickEvent::new);
        public static final MapCodec<ChangePageClickEvent> CHANGE_PAGE = ClickEventCodec.create(ChangePageClickEvent::asString, ChangePageClickEvent::new);
        public static final MapCodec<CopyToClipboardClickEvent> COPY_TO_CLIPBOARD = ClickEventCodec.create(CopyToClipboardClickEvent::getValue, CopyToClipboardClickEvent::new);
        public static final Codec<ClickEvent> CODEC = Codec.named((NamedType[])new ClickEventAction[]{ClickEventAction.OPEN_URL, ClickEventAction.OPEN_FILE, ClickEventAction.RUN_COMMAND, ClickEventAction.SUGGEST_COMMAND, ClickEventAction.CHANGE_PAGE, ClickEventAction.COPY_TO_CLIPBOARD}).verified(action -> {
            if (action.isUserDefinable()) {
                return null;
            }
            return Result.error((String)("The action " + action.getName() + " is not user definable"));
        }).typed("action", ClickEvent::getAction, action -> {
            switch (action) {
                case OPEN_URL: {
                    return OPEN_URL;
                }
                case OPEN_FILE: {
                    return OPEN_FILE;
                }
                case RUN_COMMAND: {
                    return RUN_COMMAND;
                }
                case SUGGEST_COMMAND: {
                    return SUGGEST_COMMAND;
                }
                case CHANGE_PAGE: {
                    return CHANGE_PAGE;
                }
                case COPY_TO_CLIPBOARD: {
                    return COPY_TO_CLIPBOARD;
                }
            }
            return MapCodec.failing((String)("Unknown click event action: " + (Object)action));
        });

        private static <T extends ClickEvent> MapCodec<T> create(Function<T, String> getter, MapCodecMerger.I1<String, T> constructor) {
            return MapCodecMerger.mapCodec((MapCodec)Codec.STRING.mapCodec("value").required(), getter, constructor);
        }
    }

    public static class TextFormattingCodec {
        public static final Codec<TextFormatting> CODEC = Codec.STRING.flatMap(formatting -> Result.success((Object)formatting.serialize()), s -> {
            TextFormatting formatting = TextFormatting.parse(s);
            if (formatting == null) {
                return Result.error((String)("Unknown formatting: " + s));
            }
            if (formatting.isRGBColor() && (formatting.getRgbValue() < 0 || formatting.getRgbValue() > 0xFFFFFF)) {
                return Result.error((String)("Out of range RGB value: " + s));
            }
            return Result.success((Object)formatting);
        });
    }
}

