/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer.v1_21_5;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.UUID;
import net.lenni0451.mcstructs.converter.codec.Codec;
import net.lenni0451.mcstructs.converter.model.Result;

public class ExtraCodecs_v1_21_5 {
    public static final Codec<Integer> ARGB_COLOR = Codec.oneOf((Codec[])new Codec[]{Codec.INTEGER, Codec.FLOAT.listOf(4, 4).map(i -> {
        float a = (float)(i >> 24 & 0xFF) / 255.0f;
        float r = (float)(i >> 16 & 0xFF) / 255.0f;
        float g = (float)(i >> 8 & 0xFF) / 255.0f;
        float b = (float)(i & 0xFF) / 255.0f;
        return Arrays.asList(Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(a));
    }, floats -> {
        int r = (int)(((Float)floats.get(0)).floatValue() * 255.0f);
        int g = (int)(((Float)floats.get(1)).floatValue() * 255.0f);
        int b = (int)(((Float)floats.get(2)).floatValue() * 255.0f);
        int a = (int)(((Float)floats.get(3)).floatValue() * 255.0f);
        return a << 24 | r << 16 | g << 8 | b;
    })});
    public static final Codec<URI> UNTRUSTED_URI = Codec.STRING.flatMap(uri -> Result.success((Object)uri.toString()), s -> {
        try {
            URI uri = new URI((String)s);
            if (uri.getScheme() == null) {
                throw new URISyntaxException((String)s, "Missing scheme");
            }
            if (!uri.getScheme().equalsIgnoreCase("http") && !uri.getScheme().equalsIgnoreCase("https")) {
                throw new URISyntaxException((String)s, "Unsupported scheme: " + uri.getScheme());
            }
            return Result.success((Object)uri);
        }
        catch (Throwable t) {
            return Result.error((Throwable)t);
        }
    });
    public static final Codec<String> CHAT_STRING = Codec.STRING.verified(s -> {
        for (char c : s.toCharArray()) {
            if (c != '\u00a7' && c >= ' ' && c != '\u007f') continue;
            return Result.error((String)("Illegal character: " + c));
        }
        return null;
    });
    public static final Codec<UUID> LENIENT_UUID = Codec.oneOf((Codec[])new Codec[]{Codec.INT_ARRAY_UUID, Codec.STRICT_STRING_UUID});
}

