/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer.v1_7;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.lenni0451.mcstructs.snbt.SNbt;
import net.lenni0451.mcstructs.text.Style;
import net.lenni0451.mcstructs.text.serializer.v1_7.EventSerializers_v1_7;

public class StyleSerializer_v1_7
extends EventSerializers_v1_7
implements JsonSerializer<Style> {
    public StyleSerializer_v1_7(SNbt<?> sNbt) {
        super(sNbt);
    }

    public JsonElement serialize(Style src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.isEmpty()) {
            return null;
        }
        JsonObject serializedStyle = new JsonObject();
        if (src.getBold() != null) {
            serializedStyle.addProperty("bold", Boolean.valueOf(src.isBold()));
        }
        if (src.getItalic() != null) {
            serializedStyle.addProperty("italic", Boolean.valueOf(src.isItalic()));
        }
        if (src.getUnderlined() != null) {
            serializedStyle.addProperty("underlined", Boolean.valueOf(src.isUnderlined()));
        }
        if (src.getStrikethrough() != null) {
            serializedStyle.addProperty("strikethrough", Boolean.valueOf(src.isStrikethrough()));
        }
        if (src.getObfuscated() != null) {
            serializedStyle.addProperty("obfuscated", Boolean.valueOf(src.isObfuscated()));
        }
        if (src.getColor() != null && !src.getColor().isRGBColor()) {
            serializedStyle.addProperty("color", src.getColor().serialize());
        }
        if (src.getClickEvent() != null) {
            JsonObject clickEvent = new JsonObject();
            clickEvent.addProperty("action", src.getClickEvent().getAction().getName());
            clickEvent.addProperty("value", (String)this.clickEventSerializer.serialize(src.getClickEvent()));
            serializedStyle.add("clickEvent", (JsonElement)clickEvent);
        }
        if (src.getHoverEvent() != null) {
            JsonObject hoverEvent = new JsonObject();
            hoverEvent.addProperty("action", src.getHoverEvent().getAction().getName());
            hoverEvent.add("value", context.serialize(this.hoverEventSerializer.serialize(src.getHoverEvent())));
            serializedStyle.add("hoverEvent", (JsonElement)hoverEvent);
        }
        return serializedStyle;
    }
}

