/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.llbit.nbt.ByteArrayTag;
import se.llbit.nbt.ByteTag;
import se.llbit.nbt.CompoundTag;
import se.llbit.nbt.DoubleTag;
import se.llbit.nbt.FloatTag;
import se.llbit.nbt.IntArrayTag;
import se.llbit.nbt.IntTag;
import se.llbit.nbt.ListTag;
import se.llbit.nbt.LongArrayTag;
import se.llbit.nbt.LongTag;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.ShortTag;
import se.llbit.nbt.SpecificTag;
import se.llbit.nbt.StringTag;
import se.llbit.nbt.Tag;

public final class TagUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpecificTag fromJson(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number = json.getAsNumber();
                if (number instanceof Byte) {
                    return new ByteTag((int)((Byte)number).byteValue());
                }
                if (number instanceof Short) {
                    return new ShortTag(((Short)number).shortValue());
                }
                if (number instanceof Integer) {
                    return new IntTag(((Integer)number).intValue());
                }
                if (number instanceof Long) {
                    return new LongTag(((Long)number).longValue());
                }
                if (number instanceof Float) {
                    return new FloatTag(((Float)number).floatValue());
                }
                if (!(number instanceof Double)) throw new IllegalArgumentException("Unknown JSON element: " + json);
                return new DoubleTag(((Double)number).doubleValue());
            }
            if (jsonPrimitive.isString()) {
                return new StringTag(jsonPrimitive.getAsString());
            }
            if (!jsonPrimitive.isBoolean()) throw new IllegalArgumentException("Unknown JSON primitive: " + jsonPrimitive);
            return new ByteTag(jsonPrimitive.getAsBoolean() ? 1 : 0);
        }
        if (json instanceof JsonObject) {
            CompoundTag compoundTag = new CompoundTag();
            Iterator number = ((JsonObject)json).entrySet().iterator();
            while (number.hasNext()) {
                Map.Entry property = (Map.Entry)number.next();
                compoundTag.add((String)property.getKey(), TagUtil.fromJson((JsonElement)property.getValue()));
            }
            return compoundTag;
        }
        if (json instanceof JsonArray) {
            List jsonArray = ((JsonArray)json).asList();
            if (jsonArray.isEmpty()) {
                return new ListTag(0, Collections.emptyList());
            }
            int listType = TagUtil.fromJson((JsonElement)jsonArray.get(0)).tagType();
            switch (listType) {
                case 1: {
                    byte[] bytes = new byte[jsonArray.size()];
                    int i = 0;
                    while (i < bytes.length) {
                        bytes[i] = (Byte)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                        ++i;
                    }
                    return new ByteArrayTag(bytes);
                }
                case 3: {
                    int[] ints = new int[jsonArray.size()];
                    int i = 0;
                    while (i < ints.length) {
                        ints[i] = (Integer)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                        ++i;
                    }
                    return new IntArrayTag(ints);
                }
                case 4: {
                    long[] longs = new long[jsonArray.size()];
                    int i = 0;
                    while (i < longs.length) {
                        longs[i] = (Long)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                        ++i;
                    }
                    return new LongArrayTag(longs);
                }
                default: {
                    ArrayList<SpecificTag> tagItems = new ArrayList<SpecificTag>(jsonArray.size());
                    Iterator iterator = jsonArray.iterator();
                    while (iterator.hasNext()) {
                        JsonElement jsonEl = (JsonElement)iterator.next();
                        SpecificTag subTag = TagUtil.fromJson(jsonEl);
                        if (!(subTag instanceof CompoundTag)) {
                            CompoundTag wrapper = new CompoundTag();
                            wrapper.add("", subTag);
                            subTag = wrapper;
                        }
                        tagItems.add(subTag);
                    }
                    return new ListTag(listType, tagItems);
                }
            }
        }
        if (!(json instanceof JsonNull)) throw new IllegalArgumentException("Unknown JSON element: " + json);
        return Tag.END;
    }

    public static JsonElement toJson(SpecificTag tag) {
        switch (tag.tagType()) {
            case 1: {
                return new JsonPrimitive((Number)((byte)((ByteTag)tag).getData()));
            }
            case 2: {
                return new JsonPrimitive((Number)((ShortTag)tag).getData());
            }
            case 3: {
                return new JsonPrimitive((Number)((IntTag)tag).getData());
            }
            case 4: {
                return new JsonPrimitive((Number)((LongTag)tag).getData());
            }
            case 5: {
                return new JsonPrimitive((Number)Float.valueOf(((FloatTag)tag).getData()));
            }
            case 6: {
                return new JsonPrimitive((Number)((DoubleTag)tag).getData());
            }
            case 7: {
                byte[] byteArray = ((ByteArrayTag)tag).getData();
                JsonArray jsonByteArray = new JsonArray(byteArray.length);
                for (byte b : byteArray) {
                    jsonByteArray.add((JsonElement)new JsonPrimitive((Number)b));
                }
                return jsonByteArray;
            }
            case 8: {
                return new JsonPrimitive(((StringTag)tag).getData());
            }
            case 9: {
                List items = ((ListTag)tag).items;
                JsonArray jsonList = new JsonArray(items.size());
                for (SpecificTag subTag : items) {
                    SpecificTag first;
                    CompoundTag compound;
                    if (subTag instanceof CompoundTag && (compound = (CompoundTag)subTag).size() == 1 && !(first = (SpecificTag)compound.get("")).isError()) {
                        jsonList.add(TagUtil.toJson(first));
                        continue;
                    }
                    jsonList.add(TagUtil.toJson(subTag));
                }
                return jsonList;
            }
            case 10: {
                JsonObject jsonObject = new JsonObject();
                for (NamedTag subTag : (CompoundTag)tag) {
                    jsonObject.add(subTag.name(), TagUtil.toJson(subTag.getTag()));
                }
                return jsonObject;
            }
            case 11: {
                int[] intArray = ((IntArrayTag)tag).getData();
                JsonArray jsonIntArray = new JsonArray(intArray.length);
                for (int i : intArray) {
                    jsonIntArray.add((JsonElement)new JsonPrimitive((Number)i));
                }
                return jsonIntArray;
            }
            case 12: {
                long[] longArray = ((LongArrayTag)tag).getData();
                JsonArray jsonLongArray = new JsonArray(longArray.length);
                for (long l : longArray) {
                    jsonLongArray.add((JsonElement)new JsonPrimitive((Number)l));
                }
                return jsonLongArray;
            }
        }
        throw new IllegalArgumentException("Unknown NBT tag: " + tag);
    }

    private TagUtil() {
    }
}

